#include "DataBasedBattler.h"
#include "mof/KeyFrameAnimation.h"
#include "mof/DataBasedAnimation.h"
#include <sstream>
#include "NormalAI.h"
//#include "AttackerAI.h"

et::DataBasedBattler::DataBasedBattler(const TCHAR* pName , mof::DataResourceManager* pDataResourceManager , mof::TextureManager* pTextureManager , TCHAR serialCode)
: BattlerFacade(et::ENEMY)
{
	m_pDataResourceManager = pDataResourceManager;
	mof::DataResource resource = m_pDataResourceManager->getResource(_T("data/monster.csv"));
	m_targetRow = mof::DataRow(resource , pName);
	m_pAI = NULL;

	std::basic_ostringstream<TCHAR> stream;
	stream << m_targetRow.getData( _T("Name")) << serialCode;
	BattlerParameter parameter;
	parameter.hp = m_targetRow.getIntegerData(_T("Hp"));
	parameter.maxHp = parameter.hp;
	parameter.attack = m_targetRow.getIntegerData(_T("Offense"));
	parameter.diffence = m_targetRow.getIntegerData(_T("Defense"));
	parameter.name = stream.str();
	parameter.speed = m_targetRow.getIntegerData(_T("Speed"));
	parameter.actionPoint = 3;
	parameter.dActionPoint = 0;
	setParameter(parameter);
	
	mof::DataResource typeResource = m_pDataResourceManager->getResource(_T("data/monster.type.csv"));
	m_typeRow = mof::DataRow(typeResource , m_targetRow.getData(_T("Type")).c_str());
	std::basic_ostringstream<TCHAR> stream2;
	stream2 << _T("image/") << m_typeRow.getData(_T("Image"));
	m_pGraphicsObject = new mof::Billboard(mof::Billboard::Y_FIXED , pTextureManager->getResource(stream2.str()));
	

	updateAI(m_targetRow.getData(_T("AI")).c_str());
	

	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	pAnimation->setScale(0 , mof::Vector3D(0.3f , 0.3f , 0.3f));
	pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
	getGraphicsObject()->setAnimation( 0 , mof::AnimationResource(pAnimation));
	
}

et::DataBasedBattler::~DataBasedBattler(void)
{
	
}


void et::DataBasedBattler::updateAI(const TCHAR* const pName){
	delete m_pAI;

	//AIIuWFNg
	mof::tstring ai = m_targetRow.getData(_T("AI"));
	if(ai == _T("UR^Cv"))m_pAI = new NormalAI(m_pDataResourceManager);
	else if(ai == _T("A^bJ["))m_pAI = new NormalAI(m_pDataResourceManager);
}


mof::AnimationResource et::DataBasedBattler::setMovingAnimation(mof::Vector3D& goal , int nFrame){
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	pAnimation->setPosition(0 , getPosition());
	pAnimation->setPosition(nFrame-1 , goal);
	mof::AnimationResource resource(pAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
}

mof::AnimationResource et::DataBasedBattler::setAidlingAnimation(mof::Vector3D& position ){
	if(!getParameter().alive){
		//\Ȃ
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
		pAnimation->setPosition(0 , position);
		pAnimation->setTextureRectangle(0 , mof::Line2D(1 , 1 , 1 , 1));
		mof::AnimationResource resource(pAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
	else if(getParameter().guard && getType() == et::HERO){
		//K[h
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation(true);
		pAnimation->setPosition(0 , position);
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 64*2 , 64 , 64*3));
		mof::AnimationResource resource(pAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
	else {
		mof::CascadeAnimation* pCascadeAnimation = new mof::CascadeAnimation();
		{
			mof::KeyFrameAnimation* pBaseAnimation = new mof::KeyFrameAnimation(true);
			pBaseAnimation->setPosition(0 , mof::Vector3D(position));
			pCascadeAnimation->setElement(0 , mof::AnimationResource(pBaseAnimation));
		}

		pCascadeAnimation->setElement(1 , mof::AnimationResource(
			new mof::DataBasedAnimation(m_typeRow.getData(_T("AidlingMotion")).c_str() , true)));

		mof::AnimationResource resource(pCascadeAnimation);
		getGraphicsObject()->setAnimation( 1 , resource);
		return resource;
	}
}

mof::AnimationResource et::DataBasedBattler::setCastAnimation(int category){
	
	const TCHAR* const table[] = {_T("DirectAttack1Motion") , _T("DirectAttack2Motion") , 
		_T("SpecialAttack1Motion") , _T("SpecialAttack2Motion")};

	mof::CascadeAnimation* pCascadeAnimation = new mof::CascadeAnimation();
	{
		mof::KeyFrameAnimation* pBaseAnimation = new mof::KeyFrameAnimation();
		pBaseAnimation->setPosition(0 , mof::Vector3D(getPosition()));
		//pBaseAnimation->setFinalKey(20);
		pCascadeAnimation->setElement(0 , mof::AnimationResource(pBaseAnimation));
	}
	pCascadeAnimation->setElement(1 , mof::AnimationResource(
		new mof::DataBasedAnimation(m_typeRow.getData(table[category] ).c_str() )));
	mof::AnimationResource resource(pCascadeAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
	
}

mof::AnimationResource et::DataBasedBattler::setDamagedAnimation(int level){
	mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
	if(level == 0){
		//ʏ
		mof::Vector3D backPosition = getPosition();
		backPosition.x += (getType() == et::ENEMY)? -0.1f : 0.1f;
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setPosition(10 , backPosition);
		pAnimation->setPosition(40 , backPosition);
		pAnimation->setPosition(60 , getPosition());
	
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setTextureRectangle(8 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(10 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(12 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(14 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(16 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(26 , mof::Line2D(0 , 0 , 64 , 64));
		
	}
	else if(level == 1){
		//S
		/*if(getType() == et::HERO){
			//CGAAAAA
			mof::Vector3D backPosition = getPosition();
			backPosition.x += (getType() == et::ENEMY)? -0.1f : 0.1f;
			pAnimation->setPosition(0 , getPosition());
			pAnimation->setPosition(10 , backPosition);
			pAnimation->setPosition(20 , backPosition);
			backPosition.y += 0.4;
			pAnimation->setPosition(100 , backPosition);
		
			pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
			pAnimation->setTextureRectangle(8 , mof::Line2D(64*3 , 0 , 256 , 64));
			pAnimation->setTextureRectangle(10 , mof::Line2D(1 , 1 , 1 , 1));
			pAnimation->setTextureRectangle(12 , mof::Line2D(64*3 , 0 , 256 , 64));
			pAnimation->setTextureRectangle(14 , mof::Line2D(64*3 , 64 , 256 , 64*2));
			pAnimation->setTextureRectangle(150 , mof::Line2D(64*3 , 64 , 256 , 64*2));
		}
		else{*/
		mof::Vector3D backPosition = getPosition();
		backPosition.x += (getType() == et::ENEMY)? -0.1f : 0.1f;
		pAnimation->setPosition(0 , getPosition());
		pAnimation->setPosition(10 , backPosition);
		
		pAnimation->setTextureRectangle(0 , mof::Line2D(0 , 0 , 64 , 64));
		pAnimation->setTextureRectangle(8 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(10 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(12 , mof::Line2D(64*3 , 0 , 256 , 64));
		pAnimation->setTextureRectangle(14 , mof::Line2D(1 , 1 , 1 , 1));
		pAnimation->setTextureRectangle(25 , mof::Line2D(1 , 1 , 1 , 1));
		//}
	}
	mof::AnimationResource resource(pAnimation);
	getGraphicsObject()->setAnimation( 1 , resource);
	return resource;
}


et::Action* et::DataBasedBattler::createAction(BattlerGroup* pGroup ) {
	return m_pAI->createAction(this , pGroup);
}

