#pragma once
#include <mof/widgets/WidgetView.hpp>

namespace mof{
	

	class MenuWidget  
    {
	public:
		virtual ~MenuWidget(){}
		virtual FrameNumber show(bool imidiately = false) = 0;
		virtual FrameNumber hide(bool imidiately = false) = 0;
        virtual const WidgetView& getView() const = 0;
        virtual WidgetView& getView() = 0;
		virtual void update() = 0;
        
        virtual void up() = 0;
		virtual void down() = 0;
		virtual void left() = 0;
		virtual void right() = 0;
		virtual void performAction() const = 0;

	};

}
/*
#pragma once
#include <boost/function/function0.hpp>
#include <boost/shared_ptr.hpp>
#include "mof/MenuView.hpp"
#include "mof/MenuItemInfo.hpp"

namespace mof{

	class LayoutManager;
	class WidgetView;

	class Menu : boost::noncopyable{
		struct Impl;
		boost::scoped_ptr<Impl> m_pImpl;
	public:
		
		typedef boost::function0<void> Action;
		struct MenuItem{
			MenuView* pView;
			Action action;
		};

		Menu( 
			mof::WidgetView* pBackgroundView ,
			const tstring& front , const tstring& back , 
		);
		~Menu();
		FrameNumber show(bool imidiately = false);
		FrameNumber hide(bool imidiately = false);
		void up();
		void down();
		void left();
		void right();
		void performAction() const;
		void draw() const;
		void update();

	};
}

*/
