#pragma once
#include "Symbol.h"
#include "mof/Graphics.h"
#include <vector>
#include "SymbolController.h"
#include "DungeonBuilder.h"

namespace et{

	class SymbolManager
	{
		std::vector<et::Symbol*> m_symbols;
		std::vector<et::SymbolController*> m_controllers;
		mof::TextureManager* m_pTextureManager;
		et::DungeonBuilder* m_pMapBuilder;
	public:
		SymbolManager(mof::TextureManager* pTextureManager , et::DungeonBuilder* pMapBuilder);
		virtual ~SymbolManager(void);
		virtual void update();
		virtual void draw();
		void add(SymbolController* pController);
		std::vector<et::Symbol*> testCollision(et::Symbol* pSymbol );
		std::vector<et::Symbol*>* getSymbolList(){return &m_symbols;}
		void create();
	};


};