#include "TargetMenu.h"
#include "mof/KeyFrameAnimation.h"
#include "MyWindow.h"
#include "BattlerGroup.h"
#include "BattlerFacade.h"

mof::Window* addSelectableTextItem(mof::Window* pOwner, std::vector<mof::Window*>& selectables , 
								   mof::Sprite* pSprite , mof::TextureManager* pTextureManager){
	mof::Window* pSelectable = new et::MyWindow(pSprite , pTextureManager);
	pOwner->add(pSelectable);
	selectables.push_back(pSelectable);
	return pSelectable;
}

et::TargetMenu::TargetMenu( mof::TextureManager* pTextureManager  , et::BattleData* pBattleData , et::BattleAction& action , int position )
: et::MyFrame(mof::Line2D( 0 , 0 , 200 , 300) , true , pTextureManager->getResource(_T("image/frame0.png")) )
{
	m_action = action;
	m_position = position;
	m_pBattleData = pBattleData;

	m_pSelector = NULL;
	m_pTextureManager = pTextureManager;
	std::vector<mof::Window*> selectables;

	mof::Window* pSelectable = NULL;
	//GX^[̃Xg쐬
	std::vector<BattlerFacade*> battlerList = m_pBattleData->getBattlerGroup()->getEnemyBattlerListAlive();
	for(std::vector<et::BattlerFacade*>::const_iterator itr = battlerList.begin() ; itr != battlerList.end() ; ++itr){
		addSelectableTextItem(this , selectables , mof::Sprite::createSpriteFromText((mof::tstring)(*itr)->getParameter().name , 16) , m_pTextureManager);
		
	}
	m_pSelector = new mof::SelectionModel(selectables , mof::AnimationResource());
	setVisible(true);
}

et::TargetMenu::~TargetMenu(void)
{
	delete m_pSelector;
}





void et::TargetMenu::setVisible(bool visible){
	et::MyFrame::setVisible(visible);
	if(visible){
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(m_position ,500));
		pAnimation->setPosition(10 , mof::Vector2D(m_position , 370));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
	else {
		mof::KeyFrameAnimation* pAnimation = new mof::KeyFrameAnimation();
		pAnimation->setPosition(0 , mof::Vector2D(m_position , 370));
		pAnimation->setPosition(10 , mof::Vector2D(m_position , 500));
		mof::AnimationResource resource(pAnimation);
		m_pSelector->setMenuAnimation(resource);
		setAnimation(0 , resource);
	}
}

et::MyFrame* et::TargetMenu::performAction(){
	int index = getSelectionModel()->getSelectingIndex();
	
	int cntEnemy = 0;
	for(std::vector<et::BattlerFacade*>::const_iterator itr = m_pBattleData->getBattlerGroup()->getBattlerList().begin() ;
		itr != m_pBattleData->getBattlerGroup()->getBattlerList().end() ; ++itr){
		if((*itr)->getType() != et::ENEMY || !(*itr)->getParameter().alive)continue;
		else if(index == cntEnemy++)m_action.pTarget = *itr;
	}
	m_pBattleData->setBattleAction(m_action);

	return this;
}


