package mokit.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connector;

import com.nttdocomo.util.JarInflater;

/**
 * XNb`pbh𑀍삷邽߂̋@\񋟂܂B<br>
 * 
 * [Doja]<br>
 * XNb`pbh𗘗p邽߂ɂ́AADFSPsizew肷Kv܂B<br>
 * gpłeʂJARƍv1M܂łł(KAv̏ꍇ)B<br>
 * ) SPsize = 1000,1000,1000<br>
 * 
 * [NXp菇]<br>
 * 1. 쐬GA0̘AԂŒ`܂B<br>
 * 2. GATCY(_SIZE)`܂B<br>
 * iSPsizeŎw肵eƍ킹Kv܂j<br>
 * 
 * @author Takuto Nishioka
 */
public class StoreManager {

	/**
	 * XNb`pbh GA 0
	 */
	public static final int NO_1 = 0;

	/**
	 * XNb`pbh GA 1
	 */
	public static final int NO_2 = 1;

	/**
	 * XNb`pbh GA 2
	 */
	public static final int NO_3 = 2;

	/**
	 * XNb`pbh eGÃTCY (byte)
	 */
	private static final int[] _SIZE = new int[] {
			1000, 1000, 1000
	};

	/**
	 * RXgN^͉܂B
	 */
	public StoreManager() {

	}

	/**
	 * w肵TCYŏł邩`FbN܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @param offset
	 *          /ǍJnʒuw
	 * @param len
	 *          /Ǎw
	 * @throws IOException
	 *           ȗ̈ATCYw肳ꂽꍇɔ
	 */
	private void checkSize(int area, int offset, int len) throws IOException {

		if (area >= _SIZE.length) {
			throw new IOException("[checkSize ȗ̈] area=" + area + ", offset=" + offset + ", len=" + len);

		} else if (offset + len > _SIZE[area]) {
			throw new IOException("[checkSize overflow] area=" + area + ", offset=" + offset + ", len=" + len);
		}
	}

	/**
	 * XNb`pbh̎ẅNA܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @throws IOException
	 *           NAɎsꍇɔ
	 */
	public void clear(int area) throws IOException {

		checkSize(area, 0, 0);

		// f[^㏑ăNA
		write(new byte[_SIZE[area]], area, 0);
	}

	/**
	 * XNb`pbhփf[^݂܂B
	 * 
	 * @param data
	 *          ݑΏۃf[^z
	 * @param area
	 *          Ώۗ̈
	 * @param offset
	 *          ݊Jnʒu
	 * @throws IOException
	 *           ݂Ɏsꍇɔ NullPointerException datanull̏ꍇɔ
	 */
	public void write(byte[] data, int area, int offset) throws IOException, NullPointerException {

		if (data == null) {
			throw new NullPointerException("[write null] area=" + area + ", offset=" + offset);
		}

		checkSize(area, offset, data.length);

		DataOutputStream out = null;
		try {
			out = Connector.openDataOutputStream("scratchpad:///" + area + ";pos=" + offset);
			out.write(data);
			out.flush();

		} catch (IOException e) {
			throw new IOException(e.getMessage() + "[write] area=" + area + ", offset=" + offset);

		} finally {
			try {
				if (out != null) out.close();
			} catch (IOException e) {
			}
			out = null;
		}
	}

	/**
	 * XNb`pbhf[^ǂݍ݂܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @param offset
	 *          ǂݍ݊Jnʒu
	 * @param len
	 *          ǂݍޒ
	 * @return
	 * @throws IOException
	 *           ǂݍ݂Ɏsꍇɔ
	 */
	public byte[] read(int area, int offset, int len) throws IOException {

		checkSize(area, offset, len);

		byte[] ret = new byte[len];
		DataInputStream in = null;
		try {
			in = Connector.openDataInputStream("scratchpad:///" + area + ";pos=" + offset);
			in.read(ret);

		} catch (IOException e) {
			throw new IOException(e.getMessage() + "[read] area=" + area + ", offset=" + offset + ", len=" + len);

		} finally {
			try {
				if (in != null) in.close();
			} catch (IOException e) {
			}
			in = null;
		}
		return ret;
	}

	/**
	 * XNb`pbhɋL^ꂽJart@Cw̃t@C擾܂B
	 * 
	 * @param area
	 *          SPsizeŐݒ肳ꂽ̈w
	 * @param offset
	 *          ǂݍ݊Jnʒu
	 * @param len
	 *          Jart@CTCY
	 * @param fname
	 *          擾t@C
	 * @return 擾t@CXg[Ԃ܂B
	 * @throws IOException
	 *           ǂݍ݂Ɏsꍇɔ
	 */
	public InputStream readJar(int area, int offset, int len, String fname) throws IOException {

		checkSize(area, offset, len);

		InputStream in = null;
		JarInflater ji = null;
		try {
			byte[] b = read(area, offset, len);
			if (b != null) {
				ji = new JarInflater(b);
				in = ji.getInputStream(fname);
			}

		} catch (Exception e) {
			throw new IOException(e.getMessage() + "[readJar] area=" + area + ", offset=" + offset + ", len=" + len + ", fname=" + fname);

		} finally {
			if (ji != null) ji.close();
			ji = null;
		}
		return in;
	}
}
