/*
 * Decompiled with CFR 0.152.
 */
package mokit.common;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import mokit.common.G;
import mokit.util.Logger;

public class BaseCanvas
extends Canvas {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int SELECT = 8;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_AST = 42;
    public static final int KEY_PND = 35;
    public static final int KEY_CLR = 0;
    public static final int KEY_SOFT1 = -21;
    public static final int KEY_SOFT2 = -22;
    public static final int KEY_NONE = -999;
    public static final int PRESSED_EVENT = 0;
    public static final int RELEASED_EVENT = 1;
    private int keyEvent;
    private int keyState;
    private boolean continueThread;
    private int retValue;
    private static Command[] softKey;

    public void paint(Graphics g) {
        G.setCvs(this.getWidth(), this.getHeight());
        G.setGraphics(g);
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void repaintCvs() {
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void paintCvs() {
    }

    public int startCvsThread(int time) {
        Logger.add("SYSTEM", "[cvs] startCvsThread(" + time + ")");
        this.continueThread = true;
        this.keyEvent = -999;
        this.keyState = 0;
        while (this.continueThread) {
            this.exe(this.keyEvent, this.keyState);
            this.keyEvent = -999;
            try {
                Thread.sleep(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.retValue;
    }

    public void exe(int keyEvent, int keyState) {
    }

    public void endCvsThread(int nextMode) {
        this.retValue = nextMode;
        this.continueThread = false;
    }

    public void setSoftLabel(String key1, String key2) {
        if (softKey == null) {
            softKey = new Command[2];
            BaseCanvas.softKey[0] = new Command("", 1, 0);
            BaseCanvas.softKey[1] = new Command("", 1, 1);
            this.addCommand(softKey[0]);
            this.addCommand(softKey[1]);
        }
        if (key1 != null) {
            this.removeCommand(softKey[0]);
            BaseCanvas.softKey[0] = new Command(key1, 1, 0);
            this.addCommand(softKey[0]);
        }
        if (key2 != null) {
            this.removeCommand(softKey[1]);
            BaseCanvas.softKey[1] = new Command(key2, 1, 1);
            this.addCommand(softKey[1]);
        }
    }

    public void keyPressed(int keyCode) {
        this.processEvent(0, this.getKey(keyCode));
    }

    public void keyReleased(int keyCode) {
        this.processEvent(1, this.getKey(keyCode));
    }

    private int getKey(int keyCode) {
        switch (keyCode) {
            case 0: 
            case 35: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            default: {
                switch (this.getGameAction(keyCode)) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        keyCode = this.getGameAction(keyCode);
                    }
                }
            }
        }
        return keyCode;
    }

    public void processEvent(int type, int param) {
        if (type == 0) {
            this.keyEvent = param;
            this.keyState |= 1 << param;
        }
        if (type == 1) {
            this.keyState ^= 1 << param;
        }
    }

    public boolean checkMultiKey(int key1, int key2) {
        return (1 << key1 & this.keyState) != 0 && (1 << key2 & this.keyState) != 0;
    }

    public boolean checkKey(int key) {
        return (1 << key & this.keyState) != 0 || this.keyEvent == key;
    }
}

