/*
 * Decompiled with CFR 0.152.
 */
package mokit.common;

import java.util.Stack;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mokit.common.F;
import mokit.util.Str;

public class G {
    private static int _width = 0;
    private static int _height = 0;
    private static Image _cvs;
    private static Graphics g;
    private static Graphics gon;
    private static Graphics goff;
    private static int[] lastColor;
    private static final String TAG_BOLD = "b";
    private static final String TAG_ULINE = "u";
    private static final String TAG_COLOR = "c";
    private static final String TAG_BR = "br";
    private static final String TAG_SIZE = "s";
    private static boolean USE_BOLD;
    private static boolean USE_ULINE;
    private static boolean USE_BR;
    private static Stack color;
    private static Stack font;

    static {
        USE_BOLD = false;
        USE_ULINE = false;
        USE_BR = false;
        color = new Stack();
        font = new Stack();
    }

    public static void setCvs(int width, int height) {
        _width = width;
        _height = height;
        _cvs = Image.createImage((int)_width, (int)_height);
        goff = _cvs.getGraphics();
    }

    public static int getWidth() {
        return _width;
    }

    public static int getHeight() {
        return _height;
    }

    public static void setGraphics(Graphics g2) {
        g = gon = g2;
    }

    public static Graphics getGraphics() {
        return g;
    }

    public static void lock() {
        g = goff;
    }

    public static void unlock(boolean b) {
        if (g == goff) {
            gon.drawImage(_cvs, 0, 0, 20);
        }
        g = gon;
    }

    public static void clearRect(int x1, int y1, int width, int height) {
        g.fillRect(x1, y1, width, height);
    }

    public static void clearAll() {
        G.clearRect(0, 0, 1000, 1000);
    }

    public static void drawString(String str, int x, int y) {
        g.drawString(str, x, y, 68);
    }

    public static void fillRect(int x1, int y1, int xl2, int yl2) {
        g.fillRect(x1, y1, xl2, yl2);
    }

    public static void drawRect(int x1, int y1, int xl2, int yl2) {
        g.drawRect(x1, y1, xl2, yl2);
    }

    public static void drawLine(int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static void drawImage(Image img, int x, int y) {
        g.drawImage(img, x, y, 20);
    }

    public static void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public static void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public static int[] getLastColor() {
        if (lastColor == null) {
            return new int[3];
        }
        return lastColor;
    }

    public static void setColorRGB(int c1, int c2, int c3) {
        g.setColor(c1, c2, c3);
        lastColor = new int[]{c1, c2, c3};
    }

    public static Image getImage(String url) {
        Image image = null;
        try {
            image = Image.createImage((String)("/" + url));
        }
        catch (Exception e) {
            image = null;
        }
        return image;
    }

    public static Image getImage(byte[] img) {
        return Image.createImage((byte[])img, (int)0, (int)img.length);
    }

    public static Image setTransparent(Image image, int r, int g, int b) {
        if (image == null) {
            return null;
        }
        return image;
    }

    public static void drawTagString(String str, int cvsStX, int cvsStY, int cvsEnX, int lineHeight) {
        int x = cvsStX;
        int y = cvsStY;
        int len = str.length();
        int idxSt = 0;
        int tagSt = 0;
        int tagEn = 0;
        String now = "";
        String next = "";
        F.setFont(F.FONT_TINY);
        while (idxSt < len) {
            now = str.substring(idxSt, idxSt + 1);
            int[] fs = F.getFontSize(now);
            int xmgn = fs[0] + 2;
            if (now.equals("<")) {
                next = str.substring(idxSt + 1, idxSt + 2);
                if (next.equals("/")) {
                    tagSt = idxSt + 1;
                    tagEn = str.indexOf(">", tagSt);
                    G.disableTag(str.substring(tagSt + 1, tagEn));
                } else {
                    tagSt = idxSt;
                    tagEn = str.indexOf(">", tagSt);
                    G.enableTag(str.substring(tagSt + 1, tagEn));
                }
                idxSt = tagEn;
            } else {
                if (USE_BR) {
                    x = cvsStX;
                    y += lineHeight;
                    G.disableTag(TAG_BR);
                }
                if (x >= cvsEnX) {
                    x = cvsStX;
                    y += lineHeight;
                }
                G.drawString(now, x, y);
                if (USE_BOLD) {
                    G.drawString(now, x + 1, y);
                }
                if (USE_ULINE) {
                    G.drawLine(x, y, x + xmgn, y);
                }
                x += xmgn;
            }
            ++idxSt;
        }
    }

    private static void enableTag(String tag) {
        String[] elem = Str.split(tag, "=");
        if (elem[0].equals(TAG_BOLD)) {
            USE_BOLD = true;
        } else if (elem[0].equals(TAG_BR)) {
            USE_BR = true;
        } else if (elem[0].equals(TAG_ULINE)) {
            USE_ULINE = true;
        } else if (elem[0].equals(TAG_COLOR)) {
            color.push(G.getLastColor());
            int[] c = Str.splitInt(elem[1], ",");
            G.setColorRGB(c[0], c[1], c[2]);
        } else if (elem[0].equals(TAG_SIZE)) {
            font.push(new int[]{F.getFontType()});
            int size = F.FONT_TINY;
            if (elem[1].equals("small")) {
                size = F.FONT_SMALL;
            } else if (elem[1].equals("medium")) {
                size = F.FONT_MEDIUM;
            } else if (elem[1].equals("large")) {
                size = F.FONT_LARGE;
            }
            F.setFont(size);
        }
    }

    private static void disableTag(String tag) {
        if (tag.equals(TAG_BOLD)) {
            USE_BOLD = false;
        } else if (tag.equals(TAG_BR)) {
            USE_BR = false;
        } else if (tag.equals(TAG_ULINE)) {
            USE_ULINE = false;
        } else if (tag.equals(TAG_COLOR)) {
            int[] c = (int[])color.pop();
            G.setColorRGB(c[0], c[1], c[2]);
        } else if (tag.equals(TAG_SIZE)) {
            int[] f = (int[])font.pop();
            F.setFont(f[0]);
        }
    }
}

