/*
 * Decompiled with CFR 0.152.
 */
package mokit.util;

public class Convertor {
    public static final int ZENKAKU = 0;
    public static final int HANKAKU = 1;
    public static final int HIRAKANA = 2;
    public static final int KATAKANA = 3;
    private static final char[] HAN_KANA = new char[]{'\uff61', '\uff62', '\uff63', '\uff64', '\uff65', '\uff66', '\uff67', '\uff68', '\uff69', '\uff6a', '\uff6b', '\uff6c', '\uff6d', '\uff6e', '\uff6f', '\uff70', '\uff71', '\uff72', '\uff73', '\uff74', '\uff75', '\uff76', '\uff77', '\uff78', '\uff79', '\uff7a', '\uff7b', '\uff7c', '\uff7d', '\uff7e', '\uff7f', '\uff80', '\uff81', '\uff82', '\uff83', '\uff84', '\uff85', '\uff86', '\uff87', '\uff88', '\uff89', '\uff8a', '\uff8b', '\uff8c', '\uff8d', '\uff8e', '\uff8f', '\uff90', '\uff91', '\uff92', '\uff93', '\uff94', '\uff95', '\uff96', '\uff97', '\uff98', '\uff99', '\uff9a', '\uff9b', '\uff9c', '\uff9d', '\uff9e', '\uff9f'};
    private static final char[] ZEN_KANA = new char[]{'\u3002', '\u300c', '\u300d', '\u3001', '\u30fb', '\u30f2', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30e3', '\u30e5', '\u30e7', '\u30c3', '\u30fc', '\u30a2', '\u30a4', '\u30a6', '\u30a8', '\u30aa', '\u30ab', '\u30ad', '\u30af', '\u30b1', '\u30b3', '\u30b5', '\u30b7', '\u30b9', '\u30bb', '\u30bd', '\u30bf', '\u30c1', '\u30c4', '\u30c6', '\u30c8', '\u30ca', '\u30cb', '\u30cc', '\u30cd', '\u30ce', '\u30cf', '\u30d2', '\u30d5', '\u30d8', '\u30db', '\u30de', '\u30df', '\u30e0', '\u30e1', '\u30e2', '\u30e4', '\u30e6', '\u30e8', '\u30e9', '\u30ea', '\u30eb', '\u30ec', '\u30ed', '\u30ef', '\u30f3', '\u309b', '\u309c'};
    private static final char HAN_KANA_FIRST = HAN_KANA[0];
    private static final char HAN_KANA_LAST = HAN_KANA[HAN_KANA.length - 1];

    public static String cnvNumber(String str, int type) {
        if (str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(str);
        int i = 0;
        int len = sb.length();
        while (i < len) {
            char c = sb.charAt(i);
            if (type == 1) {
                if ('\uff10' <= c && c <= '\uff19') {
                    sb.setCharAt(i, (char)(c - 65296 + 48));
                }
            } else if ('0' <= c && c <= '9') {
                sb.setCharAt(i, (char)(c - 48 + 65296));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String cnvAlphabet(String str, int type) {
        if (str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(str);
        int i = 0;
        int len = sb.length();
        while (i < len) {
            char c = sb.charAt(i);
            if (type == 1) {
                if ('\uff41' <= c && c <= '\uff5a') {
                    sb.setCharAt(i, (char)(c - 65345 + 97));
                } else if ('\uff21' <= c && c <= '\uff3a') {
                    sb.setCharAt(i, (char)(c - 65313 + 65));
                }
            } else if ('a' <= c && c <= 'z') {
                sb.setCharAt(i, (char)(c - 97 + 65345));
            } else if ('A' <= c && c <= 'Z') {
                sb.setCharAt(i, (char)(c - 65 + 65313));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String cnvKana2(String str, int type) {
        if (str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(str);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (type == 2) {
                if ('\u30a1' <= c && c <= '\u30f3') {
                    sb.setCharAt(i, (char)(c - 12449 + 12353));
                } else if (c == '\u30f5') {
                    sb.setCharAt(i, '\u304b');
                } else if (c == '\u30f6') {
                    sb.setCharAt(i, '\u3051');
                } else if (c == '\u30f4') {
                    sb.setCharAt(i, '\u3046');
                    sb.insert(i + 1, '\u309b');
                    ++i;
                }
            } else if ('\u3041' <= c && c <= '\u3093') {
                sb.setCharAt(i, (char)(c - 12353 + 12449));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String cnvKana(String str) {
        char convertedChar;
        char originalChar1;
        if (str.length() == 0) {
            return "";
        }
        if (str.length() == 1) {
            return String.valueOf(Convertor.cnvKanaChar(str.charAt(0)));
        }
        StringBuffer sb = new StringBuffer(str);
        int i = 0;
        i = 0;
        while (i < sb.length() - 1) {
            char originalChar2;
            originalChar1 = sb.charAt(i);
            char margedChar = Convertor.mergeKanaChar(originalChar1, originalChar2 = sb.charAt(i + 1));
            if (margedChar != originalChar1) {
                sb.setCharAt(i, margedChar);
                sb.deleteCharAt(i + 1);
            } else {
                char convertedChar2 = Convertor.cnvKanaChar(originalChar1);
                if (convertedChar2 != originalChar1) {
                    sb.setCharAt(i, convertedChar2);
                }
            }
            ++i;
        }
        if (i < sb.length() && (convertedChar = Convertor.cnvKanaChar(originalChar1 = sb.charAt(i))) != originalChar1) {
            sb.setCharAt(i, convertedChar);
        }
        return sb.toString();
    }

    private static char cnvKanaChar(char c) {
        if (c >= HAN_KANA_FIRST && c <= HAN_KANA_LAST) {
            return ZEN_KANA[c - HAN_KANA_FIRST];
        }
        return c;
    }

    private static char mergeKanaChar(char c1, char c2) {
        if (c2 == '\uff9e') {
            if ("_\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) > 0) {
                switch (c1) {
                    case '\uff76': {
                        return '\u30ac';
                    }
                    case '\uff77': {
                        return '\u30ae';
                    }
                    case '\uff78': {
                        return '\u30b0';
                    }
                    case '\uff79': {
                        return '\u30b2';
                    }
                    case '\uff7a': {
                        return '\u30b4';
                    }
                    case '\uff7b': {
                        return '\u30b6';
                    }
                    case '\uff7c': {
                        return '\u30b8';
                    }
                    case '\uff7d': {
                        return '\u30ba';
                    }
                    case '\uff7e': {
                        return '\u30bc';
                    }
                    case '\uff7f': {
                        return '\u30be';
                    }
                    case '\uff80': {
                        return '\u30c0';
                    }
                    case '\uff81': {
                        return '\u30c2';
                    }
                    case '\uff82': {
                        return '\u30c5';
                    }
                    case '\uff83': {
                        return '\u30c7';
                    }
                    case '\uff84': {
                        return '\u30c9';
                    }
                    case '\uff8a': {
                        return '\u30d0';
                    }
                    case '\uff8b': {
                        return '\u30d3';
                    }
                    case '\uff8c': {
                        return '\u30d6';
                    }
                    case '\uff8d': {
                        return '\u30d9';
                    }
                    case '\uff8e': {
                        return '\u30dc';
                    }
                }
            }
        } else if (c2 == '\uff9f' && "_\uff8a\uff8b\uff8c\uff8d\uff8e".indexOf(c1) > 0) {
            switch (c1) {
                case '\uff8a': {
                    return '\u30d1';
                }
                case '\uff8b': {
                    return '\u30d4';
                }
                case '\uff8c': {
                    return '\u30d7';
                }
                case '\uff8d': {
                    return '\u30da';
                }
                case '\uff8e': {
                    return '\u30dd';
                }
            }
        }
        return c1;
    }
}

