package mokit.common;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

import mokit.util.Logger;

/**
 * LoXʂ̃CNXłB<br>
 * 
 * @author Takuto Nishioka
 */
public class BaseCanvas extends Canvas {

	/**
	 * L[\܂B
	 */
	public static final int UP = Canvas.UP;

	/**
	 * L[\܂B
	 */
	public static final int DOWN = Canvas.DOWN;

	/**
	 * L[\܂B
	 */
	public static final int LEFT = Canvas.LEFT;

	/**
	 * EL[\܂B
	 */
	public static final int RIGHT = Canvas.RIGHT;

	/**
	 * L[\܂B
	 */
	public static final int SELECT = FIRE;

	/**
	 * 0L[\܂B
	 */
	public static final int KEY_0 = KEY_NUM0;

	/**
	 * 1L[\܂B
	 */
	public static final int KEY_1 = KEY_NUM1;

	/**
	 * 2L[\܂B
	 */
	public static final int KEY_2 = KEY_NUM2;

	/**
	 * 3L[\܂B
	 */
	public static final int KEY_3 = KEY_NUM3;

	/**
	 * 4L[\܂B
	 */
	public static final int KEY_4 = KEY_NUM4;

	/**
	 * 5L[\܂B
	 */
	public static final int KEY_5 = KEY_NUM5;

	/**
	 * 6L[\܂B
	 */
	public static final int KEY_6 = KEY_NUM6;

	/**
	 * 7L[\܂B
	 */
	public static final int KEY_7 = KEY_NUM7;

	/**
	 * 8L[\܂B
	 */
	public static final int KEY_8 = KEY_NUM8;

	/**
	 * 9L[\܂B
	 */
	public static final int KEY_9 = KEY_NUM9;

	/**
	 * *L[\܂B
	 */
	public static final int KEY_AST = KEY_STAR;

	/**
	 * #L[\܂B
	 */
	public static final int KEY_PND = KEY_POUND;

	/**
	 * NAL[\܂B
	 */
	public static final int KEY_CLR = 0;

	/**
	 * \tgL[1\܂B
	 */
	public static final int KEY_SOFT1 = -21;

	/**
	 * \tgL[2\܂B
	 */
	public static final int KEY_SOFT2 = -22;

	/**
	 * L[ĂȂԂ\܂B
	 */
	public static final int KEY_NONE = -999;

	/**
	 * L[_ECxg\܂B
	 */
	public static final int PRESSED_EVENT = 0;

	/**
	 * L[AbvCxg\܂B
	 */
	public static final int RELEASED_EVENT = 1;

	// L[Ɏgp
	private int keyEvent;

	// 𔻒肷ۂ͂gp
	private int keyState;

	// CanvasXbhI
	private boolean continueThread;

	// CanvasIɕԂl
	private int retValue;

	// Softkeyp
	private static Command[] softKey;

	/**
	 * Canvas`惁\bhłB<br>
	 * LoXؑ֎ɎŌĂ΂܂B
	 * 
	 * @param g
	 *          GraphicsCX^X
	 */
	public void paint(Graphics g) {

		G.setCvs(getWidth(), getHeight());
		G.setGraphics(g);
		G.lock();
		paintCvs();
		G.unlock(true);
	}

	/**
	 * Canvasĕ`悵܂B
	 * 
	 */
	public void repaintCvs() {

		G.lock();
		paintCvs();
		G.unlock(true);
	}

	/**
	 * TuNXŃI[o[Ch܂B
	 * 
	 */
	public void paintCvs() {

	}

	/**
	 * CanvasɋN郁C[vłB
	 * 
	 * @param time
	 *          X[vԊu
	 * @return MainXbh֔Cӂ̒lԂ܂B
	 */
	public int startCvsThread(int time) {

		Logger.add(Logger.SYS, "[cvs] startCvsThread(" + time + ")");
		continueThread = true;
		keyEvent = KEY_NONE;
		keyState = 0;

		while (continueThread) {
			exe(keyEvent, keyState);
			keyEvent = KEY_NONE;
			try {
				Thread.sleep(time);
			} catch (Exception e) {
			}
		}
		return retValue;
	}

	/**
	 * TuNXŃI[o[Ch܂B
	 * 
	 * @param keyEvent
	 *          xpL[p^
	 * @param keyState
	 *          ςȂpL[p^
	 */
	public void exe(int keyEvent, int keyState) {

	}

	/**
	 * CanvasXbhI܂B
	 * 
	 * @param nextMode
	 *          MainXbh֕Ԃl
	 */
	public void endCvsThread(int nextMode) {

		retValue = nextMode;
		continueThread = false;
	}

	/**
	 * \tgL[xݒ肵܂B
	 * 
	 * @param key1
	 *          \tgL[1̃x
	 * @param key2
	 *          \tgL[2̃x
	 */
	public void setSoftLabel(String key1, String key2) {

		if (softKey == null) {
			softKey = new Command[2];
			softKey[0] = new Command("", Command.SCREEN, 0);
			softKey[1] = new Command("", Command.SCREEN, 1);
			addCommand(softKey[0]);
			addCommand(softKey[1]);
		}
		if (key1 != null) {
			removeCommand(softKey[0]);
			softKey[0] = new Command(key1, Command.SCREEN, 0);
			addCommand(softKey[0]);
		}
		if (key2 != null) {
			removeCommand(softKey[1]);
			softKey[1] = new Command(key2, Command.SCREEN, 1);
			addCommand(softKey[1]);
		}
	}

	/**
	 * L[vXCxg܂B
	 */
	public void keyPressed(int keyCode) {

		processEvent(PRESSED_EVENT, getKey(keyCode));
	}

	/**
	 * L[[XCxg܂B
	 */
	public void keyReleased(int keyCode) {

		processEvent(RELEASED_EVENT, getKey(keyCode));
	}

	/**
	 * L[R[h擾܂B
	 * 
	 * @param keyCode
	 * @return
	 */
	private int getKey(int keyCode) {

		switch (keyCode) {
			case KEY_CLR:
				;
			case KEY_0:
				;
			case KEY_1:
				;
			case KEY_2:
				;
			case KEY_3:
				;
			case KEY_4:
				;
			case KEY_5:
				;
			case KEY_6:
				;
			case KEY_7:
				;
			case KEY_8:
				;
			case KEY_9:
				;
			case KEY_AST:
				;
			case KEY_POUND:
				break;
			default:
				switch (getGameAction(keyCode)) {
					case UP:
						;
					case DOWN:
						;
					case LEFT:
						;
					case RIGHT:
						;
					case SELECT:
						keyCode = getGameAction(keyCode);
				}
		}
		return keyCode;
	}

	/**
	 * L[CxgۂɌĂ΂܂B<br>
	 * LϐZbg܂B
	 * 
	 * <p>
	 * keyEvent : xpL[p^<br>
	 * keyState : ςȂpL[p^
	 * </p>
	 * 
	 * @param type
	 *          L[Cxg
	 * @param param
	 *          L[Cxgp^
	 */
	public void processEvent(int type, int param) {

		if (type == PRESSED_EVENT) {
			keyEvent = param;
			keyState |= (1 << param);
		}
		if (type == RELEASED_EVENT) {
			keyState ^= (1 << param);
		}
	}

	/**
	 * ̔s܂B
	 * 
	 * @param key1
	 *          ΏۃL[1
	 * @param key2
	 *          ΏۃL[2
	 * @return w肳ꂽL[ɉĂ ture Ԃ܂B
	 */
	public boolean checkMultiKey(int key1, int key2) {

		if (0 != (1 << key1 & keyState) && 0 != (1 << key2 & keyState)) return true;
		return false;
	}

	/**
	 * L[s܂B<br>
	 * iςȂ or 1x̂ǂ炩LłΉĂƔj
	 * 
	 * @param key
	 *          ΏۃL[
	 * @return w肳ꂽL[Ă ture Ԃ܂B
	 */
	public boolean checkKey(int key) {

		if (0 != (1 << key & keyState) || keyEvent == key) return true;
		return false;
	}

}
