/*
 * Decompiled with CFR 0.152.
 */
package mokit.ui;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Graphics;
import mokit.ui.G;
import mokit.util.DebugUtil;

public class BaseCanvas
extends Canvas {
    public static final int UP = 17;
    public static final int DOWN = 19;
    public static final int LEFT = 16;
    public static final int RIGHT = 18;
    public static final int SELECT = 20;
    public static final int KEY_0 = 0;
    public static final int KEY_1 = 1;
    public static final int KEY_2 = 2;
    public static final int KEY_3 = 3;
    public static final int KEY_4 = 4;
    public static final int KEY_5 = 5;
    public static final int KEY_6 = 6;
    public static final int KEY_7 = 7;
    public static final int KEY_8 = 8;
    public static final int KEY_9 = 9;
    public static final int KEY_AST = 10;
    public static final int KEY_PND = 11;
    public static final int KEY_IAPP = 24;
    public static final int KEY_SOFT1 = 21;
    public static final int KEY_SOFT2 = 22;
    public static final int KEY_NONE = -999;
    public static final int SOFT_LABEL_1 = 0;
    public static final int SOFT_LABEL_2 = 1;
    public static final int PRESSED_EVENT = 0;
    public static final int RELEASED_EVENT = 1;
    private static int _keyEvent;
    private static int _keyState;
    private static boolean _continueThread;
    private static int _retValue;
    private long _beforeTime;
    private long _afterTime;
    private long _sleepTime;
    private long _prevCalcTime;
    private int _frameCnt;
    private long _calcInterval;
    private long _frameTime = 20L;

    public void paint(Graphics g) {
        G.setGraphics(g);
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void repaintCvs() {
        if (G.getGraphics() != null) {
            G.lock();
            this.paintCvs();
            G.unlock(true);
        }
    }

    public void paintCvs() {
    }

    public void activateCvs() {
    }

    public void setFrameTime(int time) {
        this._frameTime = time;
    }

    public int startCvsThread() {
        DebugUtil.system("BaseMain startCvsThread()");
        _continueThread = true;
        _keyEvent = -999;
        _keyState = 0;
        this._frameCnt = 0;
        this._calcInterval = 0L;
        this._prevCalcTime = this._beforeTime = System.currentTimeMillis();
        while (_continueThread) {
            this.exe(_keyEvent, _keyState);
            _keyEvent = -999;
            this.repaintCvs();
            this._afterTime = System.currentTimeMillis();
            this._sleepTime = this._frameTime - (this._afterTime - this._beforeTime);
            if (this._sleepTime > 0L) {
                try {
                    Thread.sleep((int)this._sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._beforeTime = System.currentTimeMillis();
        }
        return _retValue;
    }

    private void calcFPS() {
        ++this._frameCnt;
        this._calcInterval += this._frameTime;
        if (this._calcInterval >= 1000L) {
            long timeNow = System.currentTimeMillis();
            int fps = (int)((long)(this._frameCnt * 1000) / (timeNow - this._prevCalcTime));
            System.out.println(fps);
            this._frameCnt = 0;
            this._calcInterval = 0L;
            this._prevCalcTime = timeNow;
        }
    }

    public void exe(int keyEvent, int keyState) {
    }

    public void endCvsThread(int nextMode) {
        DebugUtil.system("BaseMain endCvsThread(" + nextMode + ")");
        _retValue = nextMode;
        _continueThread = false;
    }

    public void setSoftLabel(String key1, String key2) {
        if (key1 != null) {
            this.setSoftLabel(0, key1);
        }
        if (key2 != null) {
            this.setSoftLabel(1, key2);
        }
    }

    public void processEvent(int type, int param) {
        _keyState = this.getKeypadState();
        if (type == 0) {
            _keyEvent = param;
        }
    }

    public boolean checkMultiKey(int key1, int key2) {
        return (1 << key1 & _keyState) != 0 && (1 << key2 & _keyState) != 0;
    }

    public boolean checkKey(int key) {
        return (1 << key & _keyState) != 0 || _keyEvent == key;
    }
}

