/*
 * Decompiled with CFR 0.152.
 */
package mokit.ui;

import com.nttdocomo.ui.AudioPresenter;
import com.nttdocomo.ui.MediaListener;
import com.nttdocomo.ui.MediaPresenter;
import com.nttdocomo.ui.UIException;
import mokit.exception.MktUIException;
import mokit.ui.SoundData;

public class SoundPlayer
implements MediaListener {
    private static SoundPlayer _soundPlayer;
    private AudioPresenter[] _audio = new AudioPresenter[2];
    public static final int BGM = 0;
    public static final int SE = 1;

    private SoundPlayer() {
        this._audio[0] = AudioPresenter.getAudioPresenter((int)0);
        this._audio[1] = AudioPresenter.getAudioPresenter((int)1);
    }

    public static SoundPlayer getInstance() {
        if (_soundPlayer == null) {
            _soundPlayer = new SoundPlayer();
        }
        return _soundPlayer;
    }

    public void setBGM(SoundData sound) throws MktUIException {
        try {
            this._audio[0].setSound(sound.getSound());
            this._audio[0].setMediaListener((MediaListener)this);
        }
        catch (UIException e) {
            throw new MktUIException(0, e.getMessage());
        }
    }

    public void setSE(SoundData sound) throws MktUIException {
        try {
            this._audio[1].setSound(sound.getSound());
        }
        catch (UIException e) {
            throw new MktUIException(0, e.getMessage());
        }
    }

    public void play(int type) {
        if (type == 0) {
            this.stop(0);
            this._audio[0].play();
        } else {
            this.stop(1);
            this._audio[1].play();
        }
    }

    public void pause(int type) {
        if (type == 0) {
            this._audio[0].pause();
        } else {
            this._audio[1].pause();
        }
    }

    public void restart(int type) {
        if (type == 0) {
            this._audio[0].restart();
        } else {
            this._audio[1].restart();
        }
    }

    public void stop(int type) {
        if (type == 0) {
            this._audio[0].stop();
        } else {
            this._audio[1].stop();
        }
    }

    public void mediaAction(MediaPresenter source, int type, int param) {
        if (type == 3) {
            this.play(0);
        }
    }
}

