package mokit.ui;

import mokit.exception.MktUIException;

import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;
import com.nttdocomo.ui.MediaImage;
import com.nttdocomo.ui.MediaManager;

/**
 * 摜߂̋@\񋟂܂B<br>
 * 
 * @author Takuto Nishioka
 */
public class MktImage {

	//DojaC[WIuWFNg
	private Image _image;

	/**
	 * RXgN^
	 */
	public MktImage() {

	}

	/**
	 * C[WIuWFNg擾܂B
	 * 
	 * @return C[WIuWFNgԂ܂B
	 */
	public Image getImage() {

		return _image;
	}

	/**
	 * \[XC[WIuWFNg擾܂B
	 * 
	 * @param url
	 *        擾pX
	 * @return C[WIuWFNgԂ܂B
	 * @throws MktUIException
	 *         摜[hɎsꍇɔ܂B
	 */
	public void setImage(String url) throws MktUIException {

		_image = null;
		try{
			MediaImage mediaImage = MediaManager.getImage("resource:///" + url);
			mediaImage.use();
			_image = mediaImage.getImage();

		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());
		}
	}

	/**
	 * C[WIuWFNg擾܂B
	 * 
	 * @param img
	 *        oCgz
	 * @return C[WIuWFNgԂ܂B
	 * @throws MktUIException
	 *         摜[hɎsꍇɔ܂B
	 */
	public void setImage(byte[] img) throws MktUIException {

		_image = null;
		try{
			MediaImage mediaImage = MediaManager.getImage(img);
			mediaImage.use();
			_image = mediaImage.getImage();

		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());
		}
	}

	/**
	 * C[WɓߐFݒ肵܂B
	 * 
	 * @param r
	 *        R
	 * @param g
	 *        G
	 * @param b
	 *        B
	 * @return ߐFݒ肳ꂽC[WIuWFNgԂ܂B
	 */
	public boolean setTransparent(int r, int g, int b) {

		if(_image == null){
			return false;
		}
		_image.setTransparentColor(Graphics.getColorOfRGB(r, g, b));
		_image.setTransparentEnabled(true);

		return true;
	}

}
