package mokit.ui;

import mokit.exception.MktUIException;

import com.nttdocomo.ui.AudioPresenter;
import com.nttdocomo.ui.MediaListener;
import com.nttdocomo.ui.MediaPresenter;
import com.nttdocomo.ui.UIException;

/**
 * TEhf[^Đ邽߂̋@\񋟂܂B
 * 
 * @author Takuto Nishioka
 */
public class SoundPlayer implements MediaListener {

	// VOg
	private static SoundPlayer _soundPlayer;
	
	// TEh}l[W[
	private AudioPresenter[] _audio;

	/**
	 * BGMTEh
	 */
	public static final int BGM = 0;

	/**
	 * SETEh
	 */
	public static final int SE = 1;

	/**
	 * TEhvC[܂B
	 */
	private SoundPlayer() {

		_audio = new AudioPresenter[2];
		_audio[BGM] = AudioPresenter.getAudioPresenter(BGM);
		_audio[SE] = AudioPresenter.getAudioPresenter(SE);
	}

	/**
	 * TEhvC[擾܂B
	 * 
	 * @return TEhvC[CX^XԂ܂B
	 */
	public static SoundPlayer getInstance() {

		if(_soundPlayer == null){
			_soundPlayer = new SoundPlayer();
		}
		return _soundPlayer;
	}

	/**
	 * BGMTEhZbg܂B
	 * 
	 * @param sound
	 *        TEhf[^
	 * @throws MktUIException
	 *         TEhf[^ĂȂꍇȂǂɔ܂B
	 */
	public void setBGM(SoundData sound) throws MktUIException{

		try{
			_audio[BGM].setSound(sound.getSound());
			_audio[BGM].setMediaListener(this);
		}catch(UIException e){
			throw new MktUIException(MktUIException.RESOURCE_NOT_READY, e.getMessage());
		}
	}

	/**
	 * SETEhZbg܂B
	 * 
	 * @param sound
	 *        TEhf[^
	 * @throws MktUIException
	 *         TEhf[^ĂȂꍇȂǂɔ܂B
	 */
	public void setSE(SoundData sound) throws MktUIException{

		try{
			_audio[SE].setSound(sound.getSound());
		}catch(UIException e){
			throw new MktUIException(MktUIException.RESOURCE_NOT_READY, e.getMessage());
		}
	}

	/**
	 * Đ܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void play(int type) {

		if(type == BGM){
			stop(BGM);
			_audio[BGM].play();
		}else{
			stop(SE);
			_audio[SE].play();
		}
	}

	/**
	 * ꎞ~܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void pause(int type) {

		if(type == BGM){
			_audio[BGM].pause();
		}else{
			_audio[SE].pause();
		}
	}

	/**
	 * ꎞ~ĊJ܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void restart(int type) {

		if(type == BGM){
			_audio[BGM].restart();
		}else{
			_audio[SE].restart();
		}
	}

	/**
	 * ~܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void stop(int type) {

		if(type == BGM){
			_audio[BGM].stop();
		}else{
			_audio[SE].stop();
		}
	}

	/**
	 * TEh֘ACxgۂɎs܂B
	 * 
	 * @param source
	 *        ʒm̔ł郁fBAv[^
	 * @param type
	 *        Cxg̎
	 * @param param
	 *        Cxg̃p[^
	 */
	public void mediaAction(MediaPresenter source, int type, int param) {

		if(type == AudioPresenter.AUDIO_COMPLETE){
			play(BGM);
		}
	}
}
