package mokit.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Bytef[^߂̋@\񋟂܂B
 * 
 * @author Takuto Nishioka
 */
public class ByteUtil {

	/**
	 * Stream[hByteɃZbg
	 * 
	 * @param in
	 *        HTTP, ResoruceȂǂStream
	 * @return bytef[^Ԃ܂B
	 * @throws IOException
	 */
	public static byte[] readInputStream(InputStream in) throws IOException {

		ByteArrayOutputStream out = null;
		byte[] w = new byte[10240];
		byte[] data;

		try{
			out = new ByteArrayOutputStream();
			while(true){
				int size = in.read(w);
				if(size <= 0) break;
				out.write(w, 0, size);
			}
			data = out.toByteArray();

		}catch(Exception e){
			data = null;

		}finally{
			try{
				if(out != null) out.close();
			}catch(IOException e){
			}
		}

		if(data == null){
			throw new IOException();
		}

		return data;
	}

	/**
	 * 񂩂oCgz擾܂B<br>
	 * MIDPΉp̃bp[\bhłB
	 * 
	 * @param str
	 *        Ώە
	 * @return oCgzԂ܂B
	 */
	public static byte[] getBytes(String str) {

		return str.getBytes();
	}

	/**
	 * oCgz񂩂當𐶐܂B<br>
	 * MIDPΉp̃bp[\bhłB
	 * 
	 * @param data
	 *        oCgz
	 * @return Ԃ܂B
	 */
	public static String byte2Str(byte[] data) {

		return new String(data);
	}
}
