/*
 * Decompiled with CFR 0.152.
 */
package mokit.ui;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import mokit.ui.G;
import mokit.util.DebugUtil;

public class BaseCanvas
extends Canvas {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int SELECT = 8;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_AST = 42;
    public static final int KEY_PND = 35;
    public static final int KEY_CLR = 0;
    public static final int KEY_SOFT1 = -21;
    public static final int KEY_SOFT2 = -22;
    public static final int KEY_NONE = -999;
    public static final int PRESSED_EVENT = 0;
    public static final int RELEASED_EVENT = 1;
    private int _keyEvent;
    private int _keyState;
    private boolean _continueThread;
    private int _retValue;
    private long _beforeTime;
    private long _afterTime;
    private long _sleepTime;
    private long _prevCalcTime;
    private int _frameCnt;
    private long _calcInterval;
    private long _frameTime = 20L;
    private static Command[] _softKey;

    public void paint(Graphics g) {
        if (G.getGraphics() == null) {
            G.setCvs(this.getWidth(), this.getHeight());
            G.setGraphics(g);
        }
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void repaintCvs() {
        this.repaint();
    }

    public void paintCvs() {
    }

    public void activateCvs() {
    }

    public void setFrameTime(int time) {
        this._frameTime = time;
    }

    public int startCvsThread() {
        DebugUtil.system("BaseMain startCvsThread()");
        this._continueThread = true;
        this._keyEvent = -999;
        this._keyState = 0;
        this._frameCnt = 0;
        this._calcInterval = 0L;
        this._prevCalcTime = this._beforeTime = System.currentTimeMillis();
        while (this._continueThread) {
            this.exe(this._keyEvent, this._keyState);
            this._keyEvent = -999;
            this.repaintCvs();
            this._afterTime = System.currentTimeMillis();
            this._sleepTime = this._frameTime - (this._afterTime - this._beforeTime);
            if (this._sleepTime > 0L) {
                try {
                    Thread.sleep((int)this._sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._beforeTime = System.currentTimeMillis();
        }
        return this._retValue;
    }

    private void calcFPS() {
        ++this._frameCnt;
        this._calcInterval += this._frameTime;
        if (this._calcInterval >= 1000L) {
            long timeNow = System.currentTimeMillis();
            int fps = (int)((long)(this._frameCnt * 1000) / (timeNow - this._prevCalcTime));
            System.out.println(fps);
            this._frameCnt = 0;
            this._calcInterval = 0L;
            this._prevCalcTime = timeNow;
        }
    }

    public void exe(int keyEvent, int keyState) {
    }

    public void endCvsThread(int nextMode) {
        DebugUtil.system("BaseMain endCvsThread(" + nextMode + ")");
        this._retValue = nextMode;
        this._continueThread = false;
    }

    public void setSoftLabel(String key1, String key2) {
        if (_softKey == null) {
            _softKey = new Command[2];
            BaseCanvas._softKey[0] = new Command("", 1, 0);
            BaseCanvas._softKey[1] = new Command("", 1, 1);
            this.addCommand(_softKey[0]);
            this.addCommand(_softKey[1]);
        }
        this.removeCommand(_softKey[0]);
        BaseCanvas._softKey[0] = key1 != null ? new Command(key1, 1, 0) : new Command("", 1, 0);
        this.addCommand(_softKey[0]);
        this.removeCommand(_softKey[1]);
        BaseCanvas._softKey[1] = key2 != null ? new Command(key2, 1, 1) : new Command("", 1, 1);
        this.addCommand(_softKey[1]);
    }

    public void keyPressed(int keyCode) {
        this.processEvent(0, this.getKey(keyCode));
    }

    public void keyReleased(int keyCode) {
        this.processEvent(1, this.getKey(keyCode));
    }

    private int getKey(int keyCode) {
        switch (keyCode) {
            case 0: 
            case 35: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            default: {
                switch (this.getGameAction(keyCode)) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        keyCode = this.getGameAction(keyCode);
                    }
                }
            }
        }
        return keyCode;
    }

    public void processEvent(int type, int param) {
        if (type == 0) {
            this._keyEvent = param;
            this._keyState |= 1 << param;
        }
        if (type == 1) {
            this._keyState ^= 1 << param;
        }
    }

    public boolean checkMultiKey(int key1, int key2) {
        return (1 << key1 & this._keyState) != 0 && (1 << key2 & this._keyState) != 0;
    }

    public boolean checkKey(int key) {
        return (1 << key & this._keyState) != 0 || this._keyEvent == key;
    }
}

