/*
 * Decompiled with CFR 0.152.
 */
package mokit.ui;

import com.jblend.media.smaf.phrase.PhrasePlayer;
import com.jblend.media.smaf.phrase.PhraseTrack;
import mokit.exception.MktUIException;
import mokit.ui.SoundData;

public class SoundPlayer {
    private static SoundPlayer _soundPlayer;
    private PhrasePlayer _player = PhrasePlayer.getPlayer();
    private PhraseTrack[] _phrase = new PhraseTrack[2];
    public static final int BGM = 0;
    public static final int SE = 1;

    private SoundPlayer() {
        this._phrase[0] = this._player.getTrack();
        this._phrase[1] = this._player.getTrack();
    }

    public static SoundPlayer getInstance() {
        if (_soundPlayer == null) {
            _soundPlayer = new SoundPlayer();
        }
        return _soundPlayer;
    }

    public void setBGM(SoundData sound) throws MktUIException {
        try {
            this._phrase[0].setPhrase(sound.getSound());
        }
        catch (Exception e) {
            throw new MktUIException(0, e.getMessage());
        }
    }

    public void setSE(SoundData sound) throws MktUIException {
        try {
            this._phrase[1].setPhrase(sound.getSound());
        }
        catch (Exception e) {
            throw new MktUIException(0, e.getMessage());
        }
    }

    public void play(int type) {
        if (type == 0) {
            this.stop(0);
            this._phrase[0].play(0);
        } else {
            this.stop(1);
            this._phrase[1].play();
        }
    }

    public void pause(int type) {
        if (type == 0) {
            this._phrase[0].pause();
        } else {
            this._phrase[1].pause();
        }
    }

    public void restart(int type) {
        if (type == 0) {
            this._phrase[0].resume();
        } else {
            this._phrase[1].resume();
        }
    }

    public void stop(int type) {
        if (type == 0) {
            this._phrase[0].stop();
        } else {
            this._phrase[1].stop();
        }
    }

    public void remove(int type) {
        if (type == 0) {
            this._phrase[0].removePhrase();
        } else {
            this._phrase[1].removePhrase();
        }
    }
}

