/*
 * Decompiled with CFR 0.152.
 */
package sample.block;

import mokit.exception.MktUIException;
import mokit.ui.G;
import mokit.ui.MktImage;
import sample.block.Bar;
import sample.block.Block;

public class Ball {
    private int w = 11;
    private int h = 11;
    private int x;
    private int y;
    private int speed_x;
    private int speed_y;
    private MktImage img = new MktImage();
    private boolean is_start = false;
    private boolean is_out = false;

    public Ball() {
        try {
            this.img.setImage("ball.png");
            this.img.setTransparent(255, 255, 255);
        }
        catch (MktUIException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public void init() {
        this.x = 90 - this.w / 2;
        this.y = 210;
        this.speed_x = 3;
        this.speed_y = 3;
        this.is_start = false;
        this.is_out = false;
    }

    public void speedUp() {
        ++this.speed_x;
        ++this.speed_y;
    }

    public void paint() {
        G.drawImage(this.img, this.x, this.y);
    }

    public MktImage getImage() {
        return this.img;
    }

    public void start() {
        this.is_start = true;
    }

    public void move() {
        if (!this.is_start) {
            return;
        }
        if (this.speed_x > 0) {
            if (this.x + this.speed_x < 180 - this.w) {
                this.x += this.speed_x;
            } else {
                this.speed_x *= -1;
            }
        } else if (this.x + this.speed_x > 10) {
            this.x += this.speed_x;
        } else {
            this.speed_x *= -1;
        }
        if (this.speed_y > 0) {
            if (this.y + this.speed_y < 240 - this.h) {
                this.y += this.speed_y;
            } else {
                this.y += 30;
                this.is_out = true;
            }
        } else if (this.y + this.speed_y > 10) {
            this.y += this.speed_y;
        } else {
            this.speed_y *= -1;
        }
    }

    public void moveWithBar(int speed) {
        if (!this.is_start) {
            this.x += speed;
        }
    }

    public void chkBarHit(Bar bar) {
        int px = this.x + this.w / 2;
        int py = this.y + this.h;
        int[] b = bar.getSize();
        if (py >= b[1] && py <= b[1] + b[3]) {
            if (px >= b[0] && px <= b[0] + b[2] / 3) {
                if (this.speed_x > 0) {
                    this.speed_x *= -1;
                }
                if (this.speed_y > 0) {
                    this.speed_y *= -1;
                }
            } else if (px >= b[0] + b[2] / 3 * 2 && px <= b[0] + b[2]) {
                if (this.speed_x < 0) {
                    this.speed_x *= -1;
                }
                if (this.speed_y > 0) {
                    this.speed_y *= -1;
                }
            } else if (px >= b[0] && px <= b[0] + b[2] && this.speed_y > 0) {
                this.speed_y *= -1;
            }
        }
    }

    public boolean chkBlockHit(Block block) {
        int px = this.x + this.w / 2;
        int py = this.y + this.h / 2;
        int[] b = block.getSize();
        if (py >= b[1] && py <= b[1] + b[3]) {
            if (px >= b[0] && px <= b[0] + b[2] / 3) {
                if (this.speed_x > 0) {
                    this.speed_x *= -1;
                }
                this.speed_y *= -1;
                return true;
            }
            if (px >= b[0] + b[2] / 3 * 2 && px <= b[0] + b[2]) {
                if (this.speed_x < 0) {
                    this.speed_x *= -1;
                }
                this.speed_y *= -1;
                return true;
            }
            if (px >= b[0] && px <= b[0] + b[2]) {
                this.speed_y *= -1;
                return true;
            }
        }
        return false;
    }

    public boolean chkOut() {
        return this.is_out;
    }
}

