package mokit.io;

import java.io.IOException;
import java.io.InputStream;

import mokit.exception.MktIOException;
import mokit.util.ByteUtil;
import mokit.util.StringUtil;

/**
 * vpeBt@C𗘗p邽߂̋@\񋟂܂B<br>
 * restH_ɉL`Ńt@CۑĂB<br>
 * gq͎RŁAu=v̊܂܂Ȃs͖܂B<br><br>
 * 
 * key1 = value1<br>
 * key2 = value2<br>
 * ...<br>
 * 
 * @author Takuto Nishioka
 */
public class PropertyReader {

	// L[ƒl؂镶
	private static final String SEPARATOR = " = ";

	// vpeBt@Cɒ`Ălꗗ
	private String[] _vals = null;

	// vpeBt@Cɒ`ĂL[ꗗ
	private String[] _keys = null;

	/**
	 * RXgN^
	 */
	public PropertyReader() {

	}

	/**
	 * restH_wt@C[h܂B
	 * 
	 * @param file
	 *        t@CpXires ȉ̃pXw肷j
	 * @throws MktIOException
	 *         [hɎsۂɔ܂B
	 */
	public void readResource(String file) throws MktIOException {

		byte[] data;
		InputStream in = null;

		try{
			in = getClass().getResourceAsStream("/"+file);
			data = ByteUtil.readInputStream(in);

		}catch(IOException e){
			data = null;

		}finally{
			try{
				if(in != null) in.close();
			}catch(IOException e){
			}
		}

		if(data == null){
			throw new MktIOException(MktIOException.PROPERTY_MISSING_FILE, file);
		}

		analyzeResource(data);
	}

	/**
	 * [hf[^͂܂B
	 * 
	 * @param data
	 *        [hf[^z
	 */
	private void analyzeResource(byte[] data) {
		
		String[] lines = StringUtil.split(ByteUtil.byte2Str(data), "\n");
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < lines.length; i++){
			if(lines[i].indexOf("=") != -1){
				sb.append(i + ",");
			}
		}
		String[] tgIdx = StringUtil.split(new String(sb), ",");
		int len = tgIdx.length - 1;
		_keys = new String[len];
		_vals = new String[len];

		for(int i = 0; i < len; i++){
			int idx = Integer.parseInt(tgIdx[i]);			
			String[] params = StringUtil.split(lines[idx], SEPARATOR);
			_keys[i] = params[0];
			_vals[i] = params[1];
		}
	}

	/**
	 * vpeBt@CɊ܂܂L[Ԃ܂B
	 * 
	 * @return L[ꗗԂ܂B
	 */
	public String[] getKeys() {
		return _keys;
	}

	/**
	 * w肵L[̒lԂ܂B
	 * 
	 * @param key
	 *        L[
	 * @return w肵L[̒lԂ܂B
	 * @throws MktIOException
	 *         w肵L[݂Ȃꍇɔ܂B
	 */
	public String getString(String key) throws MktIOException {

		for(int i = 0, len = _keys.length; i < len; i++){
			if(_keys[i].equals(key)){
				return _vals[i];
			}
		}

		throw new MktIOException(MktIOException.PROPERTY_MISSING_KEY, key);
	}

}
