package mokit.io;

import java.io.IOException;

import javax.microedition.rms.RecordStore;

/**
 * R[hXgA𑀍삷邽߂̋@\񋟂܂B<br>
 * ̃NXł́ADojaւ̈ڐAlĂ邽߁A̃R[hXgÂ݈܂B<br>
 * <br>
 * 
 * [MIDP]<br>
 * R[hXgA𗘗p邽߂ɂ́AJADMIDlet-Data-Sizew肷Kv܂B<br>
 * gpłeʂ͊{Iɍő512KBŁAJARJADƃR[hXgATCYv1M܂łłB<br>
 * ) MIDlet-Data-Size: 512000<br>
 * 
 * [NXp菇]<br>
 * 1. 쐬郌R[h1̘AԂŒ`܂B<br>
 * 2. R[hTCY(_SIZE)`܂B<br>
 * iSĂ̍vMIDlet-Data-SizeȉɂȂ悤ɂ܂j<br>
 * 
 * @author Takuto Nishioka
 */
public class StoreManager {

	/**
	 * R[hXgA RSTORE R[h ID=1
	 */
	public static final int NO_1 = 1;

	/**
	 * R[hXgA RSTORE R[h ID=2
	 */
	public static final int NO_2 = 2;

	/**
	 * R[hXgA RSTORE R[h ID=3
	 */
	public static final int NO_3 = 3;

	// R[hTCY (byte)
	private static final int[] _SIZE = new int[] {
			1000, 1000, 1000
	};

	// R[hXgAIuWFNg
	private static RecordStore _rs;

	/**
	 * RXgN^͉܂B
	 */
	public StoreManager() {

	}

	/**
	 * R[hXgAI[v܂B
	 * 
	 * @param isInit
	 *          R[hXgAȂꍇɍ쐬邩ǂ
	 * @throws IOException
	 *           R[hI[vɎsꍇɔ܂B
	 */
	private void openRstore(boolean isInit) throws IOException {

		try {
			// pȂ̂Ŗ̂͌Œ
			_rs = RecordStore.openRecordStore("RSTORE", isInit);
		} catch (Exception e) {
			_rs = null;
			throw new IOException("[openRstore OPENs]");
		}
	}

	/**
	 * R[hXgAN[Y܂B
	 */
	private void closeRstore() {

		try {
			if (_rs != null) _rs.closeRecordStore();
		} catch (Exception e) {
			_rs = null;
		}
	}

	/**
	 * R[hXgA܂B
	 * 
	 * @throws IOException
	 *           R[h̏Ɏsꍇɔ܂B
	 */
	private void initRstore() throws IOException {

		try {
			openRstore(true);
			int rnum = _rs.getNumRecords();

			// R[hύXĂ烌R[hS폜
			if (rnum != 0 && rnum != _SIZE.length) {
				for (int i = 0; i < rnum; i++) {
					_rs.deleteRecord(i);
				}
				rnum = 0;
			}

			// R[h
			if (rnum == 0) {
				for (int i = 0; i < _SIZE.length; i++) {
					byte[] w = new byte[_SIZE[i]];
					_rs.addRecord(w, 0, w.length);
				}
			}

		} catch (Exception e) {
			throw new IOException(e.getMessage() + "[initRstore s]");

		} finally {
			closeRstore();
		}
	}

	/**
	 * w肵TCYŏł邩`FbN܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @param offset
	 *          /ǍJnʒuw
	 * @param len
	 *          /Ǎw
	 * @throws IOException
	 *           ȗ̈ATCYw肳ꂽꍇɔ܂B
	 */
	private void checkSize(int area, int offset, int len) throws IOException {

		// R[hXgA
		initRstore();

		if (area >= _SIZE.length) {
			throw new IOException("[checkSize ȗ̈] area=" + area + ", offset=" + offset + ", len=" + len);

		} else if (offset + len > _SIZE[area]) {
			throw new IOException("[checkSize overflow] area=" + area + ", offset=" + offset + ", len=" + len);
		}
	}

	/**
	 * R[hXgA̎ẅNA܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @throws IOException
	 *           NAɎsꍇɔ܂B
	 */
	public void clear(int area) throws IOException {

		checkSize(area, 0, 0);

		// f[^㏑ăNA
		write(new byte[_SIZE[area]], area, 0);
	}

	/**
	 * R[hXgAփf[^݂܂B
	 * 
	 * @param data
	 *        ݑΏۃf[^z
	 * @param area
	 *        Ώۗ̈
	 * @param offset
	 *        ݊Jnʒu
	 * @throws IOException
	 *         ݂Ɏsꍇɔ܂B
	 * @throws NullPointerException
	 *         datanull̏ꍇɔ܂B
	 */
	public void write(byte[] data, int area, int offset) throws IOException, NullPointerException {

		if (data == null) {
			throw new NullPointerException("[write null] area=" + area + ", offset=" + offset);
		}

		checkSize(area, offset, data.length);

		try {
			openRstore(true);
			_rs.setRecord(area, data, offset, data.length);

		} catch (Exception e) {
			throw new IOException(e.getMessage() + "[write] area=" + area + ", offset=" + offset);

		} finally {
			closeRstore();
		}
	}

	/**
	 * R[hXgAf[^ǂݍ݂܂B
	 * 
	 * @param area
	 *          Ώۗ̈
	 * @param offset
	 *          ǂݍ݊Jnʒu
	 * @param len
	 *          ǂݍޒ
	 * @throws IOException
	 *           ǂݍ݂Ɏsꍇɔ܂B
	 */
	public byte[] read(int area, int offset, int len) throws IOException {

		checkSize(area, offset, len);

		byte[] ret = new byte[len];
		try {
			openRstore(false);
			System.arraycopy(_rs.getRecord(area), offset, ret, 0, len);

		} catch (Exception e) {
			throw new IOException(e.getMessage() + "[read] area=" + area + ", offset=" + offset + ", len=" + len);

		} finally {
			closeRstore();
		}
		return ret;
	}
}
