package mokit.ui;

import com.jblend.media.smaf.phrase.PhrasePlayer;
import com.jblend.media.smaf.phrase.PhraseTrack;

import mokit.exception.MktUIException;

/**
 * TEhf[^Đ邽߂̋@\񋟂܂B<br>
 * <br>
 * JSCLł͉Lf[^̓ĐT|[gĂ܂ÃNXłSMAF(mmf)T|[gĂ܂B<br>
 * <li>SMAF/Phrase(spf)F4a~4gbN
 * <li>SMAF(mmf)F16a~1gbN
 * 
 * @author Takuto Nishioka
 */
public class SoundPlayer {

	// VOg
	private static SoundPlayer _soundPlayer;

	private PhrasePlayer _player;

	private PhraseTrack[] _phrase;

	/**
	 * BGMTEh
	 */
	public static final int BGM = 0;

	/**
	 * SETEh
	 */
	public static final int SE = 1;

	/**
	 * TEhvC[܂B
	 */
	private SoundPlayer() {

		_player = PhrasePlayer.getPlayer();
		_phrase = new PhraseTrack[2];
		_phrase[BGM] = _player.getTrack();
		_phrase[SE] = _player.getTrack();
	}

	/**
	 * TEhvC[擾܂B
	 * 
	 * @return TEhvC[CX^XԂ܂B
	 */
	public static SoundPlayer getInstance() {

		if(_soundPlayer == null){
			_soundPlayer = new SoundPlayer();
		}
		return _soundPlayer;
	}

	/**
	 * BGMTEhZbg܂B
	 * 
	 * @param sound
	 *        TEhf[^
	 * @throws MktUIException
	 *         TEhf[^ĂȂꍇȂǂɔ܂B
	 */
	public void setBGM(SoundData sound) throws MktUIException {

		try{
			_phrase[BGM].setPhrase(sound.getSound());	
		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_NOT_READY, e.getMessage());
		}
	}

	/**
	 * SETEhZbg܂B
	 * 
	 * @param sound
	 *        TEhf[^
	 * @throws MktUIException
	 *         TEhf[^ĂȂꍇȂǂɔ܂B
	 */
	public void setSE(SoundData sound) throws MktUIException {

		try{
			_phrase[SE].setPhrase(sound.getSound());
		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_NOT_READY, e.getMessage());
		}
	}

	/**
	 * Đ܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void play(int type) {

		if(type == BGM){
			stop(BGM);
			_phrase[BGM].play(0);
		}else{
			stop(SE);
			_phrase[SE].play();
		}
	}

	/**
	 * ꎞ~܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void pause(int type) {

		if(type == BGM){
			_phrase[BGM].pause();
		}else{
			_phrase[SE].pause();
		}
	}

	/**
	 * ꎞ~ĊJ܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void restart(int type) {

		if(type == BGM){
			_phrase[BGM].resume();
		}else{
			_phrase[SE].resume();
		}
	}

	/**
	 * ~܂B
	 * 
	 * @param type
	 *        TEh̎
	 */
	public void stop(int type) {

		if(type == BGM){
			_phrase[BGM].stop();
		}else{
			_phrase[SE].stop();
		}
	}
	
	/**
	 * TEhJ܂B
	 * 
	 * @param type
	 *        JTEh
	 */
	public void remove(int type){

		if(type == BGM){
			_phrase[BGM].removePhrase();
		}else{
			_phrase[SE].removePhrase();
		}
	}

}
