package sample;

import sample.block.Ball;
import sample.block.Bar;
import sample.block.Block;
import mokit.exception.MktUIException;
import mokit.ui.BaseCanvas;
import mokit.ui.G;
import mokit.ui.MktFont;
import mokit.ui.MktImage;

/**
 * wi摜 悭Pꂽfމl ̑fނ𗘗pĒĂ܂B
 * http://animehack.jp/material/
 */

public class CvsGame extends BaseCanvas {

	// \tgL[`
	private static String LABEL_TOP = "TOP";
	private static String LABEL_END_APP = "I";

	// Xe[W`
	private static final int[][] STAGE = {
		{3,3,3,3,3, 0,0,0,0,0, 2,2,2,2,2, 0,0,0,0,0, 1,1,1,1,1},
		{3,3,3,3,3, 0,0,0,0,0, 2,2,2,2,2, 0,0,0,0,0, 1,1,1,1,1, 0,0,0,0,0, 3,3,3,3,3, 0,0,0,0,0, 2,2,2,2,2},
		{3,3,3,3,3, 0,0,0,0,0, 2,2,2,2,2, 0,0,0,0,0, 1,1,1,1,1, 0,0,0,0,0, 3,3,3,3,3, 0,0,0,0,0, 2,2,2,2,2, 0,0,0,0,0, 1,1,1,1,1}
	};

	// Pӂ̃ubN
	private static final int BLOCK_MAX_COL_NUM = 5;

	// Ct[XW
	public static final int FRAME_SX = 10;

	// Ct[YW
	public static final int FRAME_SY = 10;

	// Ct[̕
	public static final int FRAME_WIDTH = 170;

	// Ct[̍
	public static final int FRAME_HEIGHT = 230;

	// Xe[^XFvC
	private static final int STATUS_NOW_PLAYING = 1;
	
	// Xe[^XFNA
	private static final int STATUS_CLEAR = 2;
	
	// Xe[^XFQ[I[o[
	private static final int STATUS_GAMEOVER = 3;
	
	// ݂̃Xe[W
	private int stage_num = 0;

	// Q[̏
	private int game_status = 0;

	// c@
	private int remain_player = 3;
	
	// _
	private int score = 0;

	// Xe[W̃ubN
	private int block_max_num = 0;

	// Xe[W̔wi摜
	private MktImage background;
		
	// Q[֘AIuWFNg
	private Bar bar;
	private Ball ball;
	private Block[] block;

	public CvsGame() {
		
		initStage(0);
	}

	public void activateCvs() {

		setSoftLabel(LABEL_TOP, LABEL_END_APP);
	}

	public void initStage(int num) {

		block_max_num = STAGE[num].length;
		
		ball = new Ball();
		bar = new Bar();
		block = new Block[block_max_num];

		for(int i = 0; i < block_max_num; i++){
			block[i] = new Block(i % BLOCK_MAX_COL_NUM, i / BLOCK_MAX_COL_NUM, STAGE[num][i]);
		}
		
		// wi摜[h
		background = new MktImage();
		try{
			if(stage_num % 3 == 0){
				background.setImage("sky.png");
			}else if(stage_num % 3 == 1){
				background.setImage("sky2.png");
			}else if(stage_num % 3 == 2){
				background.setImage("sky3.png");				
			}
		}catch(MktUIException e){
			e.printStackTrace();
		}
		
		// Xs[hAbv!
		for(int i=0; i<stage_num; i++){
			ball.speedUp();
		}
		
		// vCJn
		game_status = STATUS_NOW_PLAYING;
	}
	
	public void paintCvs() {

		MktFont.setFont(MktFont.FONT_TINY);

		// wi
		G.drawImage(background, 0, 0);
		
		// Ct[
		G.setColorRGB(0,0,0,50);
		//G.fillRect(FRAME_SX, FRAME_SY, FRAME_WIDTH, FRAME_HEIGHT);
		G.fillAlphaRect(FRAME_SX, FRAME_SY, FRAME_WIDTH, FRAME_HEIGHT);

		G.setColorRGB(220,220,220);
		G.drawRect(FRAME_SX-1, FRAME_SY-1, FRAME_WIDTH+1, FRAME_HEIGHT+1);
		
		// SCORE		
		int fx = 198;
		int fy = 40;
		
		G.drawBorderString("SCORE", fx, fy, new int[]{0,0,0}, new int[]{255,255,255});
		
		String _score = ""+score;
		for(int i=_score.length(); i<5; i++){
			_score = " "+_score;			
		}		
		G.drawBorderString(_score, fx, fy+20, new int[]{255,0,0}, new int[]{255,255,255});

		// c@
		G.drawBorderString(" c", fx, 180, new int[]{0,0,0}, new int[]{255,255,255});
		for(int i=0; i<remain_player-1; i++){
			G.drawImage(ball.getImage(), fx + i*15, 190);
		}

		// IuWFNg		
		bar.paint();
		ball.paint();
		for(int i = 0; i < block_max_num; i++){
			block[i].paint();
		}
		
		// NA/Q[I[o[
		if(game_status == STATUS_CLEAR){
			String str_clear = "STAGE CLEAR !";		
			G.drawBorderString(str_clear, 
					(FRAME_SX+FRAME_WIDTH)/2 - MktFont.getFontSize(str_clear)[0]/2, 
					FRAME_HEIGHT/2, 
					new int[]{0,0,255}, new int[]{255,255,255});		
			
		}else if(game_status == STATUS_GAMEOVER){
			String str_clear = "GAME OVER";		
			G.drawBorderString(str_clear, 
					(FRAME_SX+FRAME_WIDTH)/2 - MktFont.getFontSize(str_clear)[0]/2, 
					FRAME_HEIGHT/2, 
					new int[]{255,0,0}, new int[]{255,255,255});		
		}
	}

	public void exe(int keyEvent, int keyState) {

		// \tgL[
		if(keyEvent == KEY_SOFT1){
			endCvsThread(Main.MODE_TITLE);
		}
		if(keyEvent == KEY_SOFT2){
			endCvsThread(Main.MODE_END_APP);
		}
		
		if(game_status == STATUS_NOW_PLAYING){
		
			// Eړ
			if(checkKey(LEFT)){
				ball.moveWithBar(bar.moveLeft());
	
			}else if(checkKey(RIGHT)){
				ball.moveWithBar(bar.moveRight());
			}
	
			// Q[Jn
			if(keyEvent == SELECT){
				ball.start();
			}
	
			// Ԃ̍XV
			updateStatus();
		
		}else if(game_status == STATUS_CLEAR){

			// Q[Jn
			if(keyEvent == SELECT){
				initStage(++stage_num);
			}

		}else if(game_status == STATUS_GAMEOVER){

			
		}
	}

	public void updateStatus(){

		// {[ړ
		ball.move();

		// o[Ƃ̓蔻
		ball.chkBarHit(bar);

		// ubNƂ̓蔻
		int remain_num = 0;
		for(int i = 0; i < block_max_num; i++){
			if(!block[i].isHit()){
				remain_num++;
				if(ball.chkBlockHit(block[i])){
					block[i].hit();
					score += block[i].getScore();
				}
			}
		}
		
		// NA
		if(remain_num == 0){
			game_status = STATUS_CLEAR;
			bar.init();
			ball.init();
		}

		// hbv
		if(ball.chkOut()){			
			if(remain_player-- > 1){
				bar.init();
				ball.init();

				// Xs[hAbv
				for(int i=0; i<stage_num; i++){
					ball.speedUp();
				}
				
			}else{
				game_status = STATUS_GAMEOVER;
			}			
		}		
	}
	
}

