package sample.block;

import sample.CvsGame;
import mokit.exception.MktUIException;
import mokit.ui.G;
import mokit.ui.MktImage;

public class Block {

	// ubN\
	public static int TYPE_NON = 0;

	// ԃubN
	public static int TYPE_RED = 1;

	// ubN
	public static int TYPE_YELLOW = 2;

	// ΃ubN
	public static int TYPE_GREEN = 3;

	// ubN^Cv
	private int type;

	// _vZp
	private int score_ratio = 10;
	
	// qbgĂ邩ǂ
	private boolean hit = false;
	
	// 摜CX^X
	private static MktImage img;

	// ubN摜̕
	private int w = 30;

	// ubN摜̍
	private int h = 14;

	// ubN̕\ʒuX
	private int x = 0;

	// ubN̕\ʒuY
	private int y = 0;

	// 摜̐؂oʒuX
	private int imgx = 0;

	// 摜̐؂oʒuY
	private int imgy = 0;

	public Block(int col, int row, int blocktype) {

		x = col * w;
		y = row * h;

		type = blocktype;

		if(type == TYPE_NON){
			hit = true;

		}else if(type == TYPE_RED){
			imgy = 0;

		}else if(type == TYPE_YELLOW){
			imgy = 14;

		}else if(type == TYPE_GREEN){
			imgy = 28;
		}

		x += CvsGame.FRAME_SX + 10;
		y += CvsGame.FRAME_SY + 10;

		img = new MktImage();
		try{
			img.setImage("block.png");
		}catch(MktUIException e){
			e.printStackTrace();
		}
	}

	public void paint() {

		if(!hit){
			G.drawScaledImage(img, x, y, w, h, imgx, imgy, w, h);
		}
	}

	public int[] getSize() {

		return new int[]{x, y, w, h};
	}

	public void hit() {

		hit = true;
	}

	public boolean isHit() {

		return hit;
	}
	
	public int getScore(){
		
		return type * score_ratio;
	}

}
