package mokit.ui;

import mokit.exception.MktUIException;

import com.docomostar.ui.Graphics;
import com.docomostar.ui.Image;
import com.docomostar.media.MediaImage;
import com.docomostar.media.MediaManager;

/**
 * 摜߂̋@\񋟂܂B<br>
 * 
 * @author Takuto Nishioka
 */
public class MktImage {

	//C[WIuWFNg
	private Image _image;

	/**
	 * RXgN^
	 */
	public MktImage() {

	}

	/**
	 * C[WIuWFNg擾܂B
	 */
	public Image getImage() {

		return _image;
	}

	/**
	 * \[XC[WIuWFNg擾܂B
	 * 
	 * @param url
	 *        擾pX
	 * @throws MktUIException
	 *         摜[hɎsꍇɔ܂B
	 */
	public void setImage(String url) throws MktUIException {

		_image = null;
		try{
			MediaImage mediaImage = MediaManager.getImage("resource:///" + url);
			mediaImage.use();
			_image = mediaImage.getImage();

		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());
		}
	}

	/**
	 * C[WIuWFNg擾܂B
	 * 
	 * @param img
	 *        oCgz
	 * @throws MktUIException
	 *         摜[hɎsꍇɔ܂B
	 */
	public void setImage(byte[] img) throws MktUIException {

		_image = null;
		try{
			MediaImage mediaImage = MediaManager.getImage(img);
			mediaImage.use();
			_image = mediaImage.getImage();

		}catch(Exception e){
			throw new MktUIException(MktUIException.RESOURCE_LOAD_FAILED, e.getMessage());
		}
	}

	/**
	 * C[WɓߐFݒ肵܂B
	 * 
	 * @param r
	 *        R
	 * @param g
	 *        G
	 * @param b
	 *        B
	 * @return ߐFݒ肳ꂽC[WIuWFNgԂ܂B
	 */
	public boolean setTransparent(int r, int g, int b) {

		if(_image == null){
			return false;
		}
		_image.setTransparentColor(Graphics.getColorOfRGB(r, g, b));
		_image.setTransparentEnabled(true);

		return true;
	}

}
