%define name    mol
%define version 0.4.1
%define release 0mol1

Summary:     Core Program for Make One Linux
Summary(ja): Make One Linuxの中核をなすプログラム
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     %{name}-%{version}.tar.gz
Group:       System Environment/Base
License:     GNU GPL version2
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root
BuildArch:   noarch
Requires:    hwsetup-mol, ddcxinfo-mol, syslinux-mol, busybox-mol

%description
mol is a software for making 1CD/DVD Linux from your Linux distribution installed in harddisk.

%description -l ja
molはハードディスクにインストールしたLinuxディストリビューションを元にしてオリジナル1CD/DVD Linuxを作成するためのソフトウェアです。

%prep
rm -rf ${RPM_BUILD_ROOT}
%setup -n %{name}-%{version}

%build
%configure
make

%install
%makeinstall

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%config /etc/%{name}/exclude-file.list
%config /etc/%{name}/exclude-package.list
%config /etc/%{name}/include-module.list
%config /etc/%{name}/molmake.conf
%config /etc/%{name}/molmakerc
/usr/libexec/autosetup-mol
/usr/libexec/devcheck
/usr/libexec/linuxrc
/usr/libexec/xsetup-mol
/usr/sbin/mkinitrd-mol
/usr/sbin/mkisofs-mol
/usr/sbin/mksquashfs-mol
/usr/sbin/molmake
/usr/share/%{name}/dependence
/usr/share/%{name}/isolinux

%changelog
* Tue Jan 17 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.1-0mol1
- added install section and some fixes to online manual.
- modified log(Sat Jan 07 2006).
* Sat Jan 07 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- changed name, dgel to Keicho Kondo
- renamed molmake to mol
* Sat Dec 31 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.0-0mol1
- initial build for Make One Linux
* Thu Nov 17 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.2-mol1
- renamed package
* Sat Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.1-mod1
- add BuildArch tag
- add BuildPrereq tag
- fix mkinitrd-mod.sh
- fix mksquashfs-mod.sh
- fix mkisofs-mod.sh
* Wed Oct 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.0-mod1
- rename package and some files
- add exclude-package.list
- add exclude-file.list
- add include-module.list
- add build directory
- remove isolinux directry
* Wed Jul 6 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.2-0mod1
- modified for busybox
- add mod-installerrc file
- remove functions file
* Fri Jun 23 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-3mod1
- rewrite README
- remove COPYING
* Sun Jun 19 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-2mod1
- reviewed the representation of release version
* Thu Jun 16 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-1
- fixed overlay system
* Sat Jun 11 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-0
- change output style
- mkinitrd.mod use "find" command, not "locate".
- COPYING file added
* Sun Jun 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.0-0
- initial build for Make One Disk

#-----------------------------------------------------------------------

%package doc
Summary:     Make One Linux Document Files
Summary(ja): Make One Linuxドキュメント
Group:       Documentation

%description doc
mol-doc is Make One Linux document files.
This package contains online manual, too.

%description doc -l ja
mol-docはMake One Linuxのドキュメントファイルです。
このパッケージにはオンラインマニュアルも含まれています。

%files doc
%defattr(-,root,root)
%doc /usr/share/doc/%{name}-%{version}/AUTHORS
%doc /usr/share/doc/%{name}-%{version}/COPYING
%doc /usr/share/doc/%{name}-%{version}/ChangeLog
%doc /usr/share/doc/%{name}-%{version}/INSTALL
%doc /usr/share/doc/%{name}-%{version}/NEWS
%doc /usr/share/doc/%{name}-%{version}/README
%doc /usr/share/doc/%{name}-%{version}/SETUP
%doc /usr/share/doc/%{name}-%{version}/online-manual

%changelog doc
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.1-0mol1
- added acknowledgement and some fixes
* Sat Dec 31 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.0-0mol1
- initial build for Make One Linux
* Sun Nov 20 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.2-mol1
- added NEWS file
- renamed package
* Sat Nov 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.1-mod1
- for Make One Disk 0.3.1
* Wed Oct 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.0-mod1
- initial build for Make One Disk

#-----------------------------------------------------------------------

%package release
Summary:     Make One Linux Release File
Summary(ja): Make One Linuxリリースファイル
Group:       System Environment/Base

%description release
mol-release is Make One Linux Release File.

%description release -l ja
mol-releaseはMake One Linuxのリリースファイルです。

%files release
%defattr(-,root,root)
/etc/%{name}/VERSION

%changelog release
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.1-0mol1
- update to 0.4.1
* Sat Dec 31 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.4.0-0mol1
- initial build for Make One Linux
* Thu Nov 17 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.2-mol1
- renamed package
* Sat Nov 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.1-mod1
- for Make One Disk 0.3.1
* Wed Oct 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.3.0-mod1
- separate document files from this package
* Wed Jul 6 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.2.0a-mod1
- fix squashfs error
* Sun Jul 3 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.2.0-mod1
- initial build for Make One Disk

