#!/bin/bash
#========================================================#
# Make One Linux -- autosetup-mol script
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
# This script automatically sets up Make One Linux system.
#

## === Set environment === ##
PATH="/exec:/bin:/usr/bin:/sbin:/usr/sbin"; export PATH
umask 0022

# set color
RESET="]R"       # Reset fb color mode
CRE="
[K"       # Erase to end of line
CLEAR="c"        # Clear and reset Screen
NORMAL="[0;39m"  # Normal Color
RED="[1;31m"     # Failure or error message
GREEN="[1;32m"   # Success message
YELLOW="[1;33m"  # Descriptions
BLUE="[1;34m"    # System message
MAGENTA="[1;35m" # Found devices or drivers
CYAN="[1;36m"    # Questions
WHITE="[1;37m"   # Hint

## === Check boot command line === ##
CMDLINE="$(cat /proc/cmdline)"

## === Set functions === ##
getbootparam()
{
	case "$CMDLINE" in
		*\ $1=*) ;;
		$1=*) ;;
		*) return 1 ;;
	esac
	result="${CMDLINE##*$1=}"
	result="${result%%[     ]*}"
	echo "$result"
	return 0
}

checkbootparam()
{
	case "$CMDLINE" in
		*\ $1*) return 0 ;;
		$1*)    return 0 ;;
	esac
	return 1
}

## === No kernel messages === ##
echo "0" > /proc/sys/kernel/printk

## === Executing hwsetup-mol === ##
if [ -d /etc/sysconfig/mol ]
then
	for f in $(ls /etc/sysconfig/mol 2>/dev/null)
	do
		for conf in floppy mol mouse netcard sound xserver
		do
			[ "$f" = "$conf" ] && mv -f /etc/sysconfig/mol/$f /etc/sysconfig/mol/$f.tmp
		done
	done
else
	mkdir -p /etc/sysconfig/mol
fi
hwsetup-mol -p

## === XkbLayout === ##
case $(grep -v "^#" /etc/X11/xorg.conf | awk '/XkbLayout/{print $3}') in *jp*) echo "XKEYBOARD=\"jp\"" >> /etc/sysconfig/mol/keyboard ;; esac

## === Read in what hwsetup-mol has found === ##
[ -f /etc/sysconfig/mol/mol ] && . /etc/sysconfig/mol/mol

## === Videocard === ##
[ -f /etc/X11/xorg.conf ] && mv /etc/X11/xorg.conf /etc/X11/xorg.conf.backup
xsetup-mol

## === Soundcard === ##
NOAUDIO=""
if checkbootparam "noaudio"
then
	NOAUDIO="yes"
elif [ -n "${SOUND_FULLNAME}" -o -n "${SOUND_DRIVER}" ]
then
	echo " ${GREEN}Soundcard is ${YELLOW}${SOUND_FULLNAME}${GREEN} driver=${MAGENTA}${SOUND_DRIVER}${NORMAL}"
	sed -e 's|@@SOUND@@|'"${SOUND_DRIVER}"'|g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
	mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
else
	NOAUDIO="yes"
fi
if [ -n "${NOAUDIO}" ]
then
	echo " ${BLUE}Skipping Soundcard detection.${NORMAL}"
	sed -e 's|@@SOUND@@||g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
	mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
fi

## === Networkcard === ##
NONETWORK=""
if checkbootparam "nonetwork" || [ -z "${NETCARD_FULLNAME}" -o -z "${NETCARD_DRIVER}" ]
then
	echo " ${BLUE}Skipping Netcard detection.${NORMAL}"
	sed -e 's|@@NET@@||g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
	mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
else
	NETCARD_DEVICE="$(awk -F: '/eth.:|tr.:/{print $1}' /proc/net/dev | awk -F' ' '{print $1}' 2>/dev/null)"
	echo " ${GREEN}Netcard is ${YELLOW}${NETCARD_FULLNAME}${GREEN} at ${MAGENTA}${NETCARD_DEVICE} ${GREEN}driver=${MAGENTA}${NETCARD_DRIVER}${NORMAL}"
	sed -e 's|@@NET@@|'"alias ${NETCARD_DEVICE} ${NETCARD_DRIVER}"'|g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
	mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in

	if checkbootparam "nodhcp"
	then
		echo " ${BLUE}Skipping DHCP broadcast/network detection as requested on boot commandline.${NORMAL}"
	elif checkbootparam "ipaddr" && checkbootparam "netmask" && checkbootparam "gateway" && checkbootparam "netdev"
	then
		IPADDR="$(getbootparam ipaddr 2>/dev/null)"
		NETMASK="$(getbootparam netmask 2>/dev/null)"
		GATEWAY="$(getbootparam gateway 2>/dev/null)"
		NETDEV="$(getbootparam netdev 2>/dev/null)"
		echo " ${GREEN}Network device ${MAGENTA}${NETDEV} ${GREEN}detected, IP is ${YELLOW}${IPADDR}${GREEN}.${NORMAL}"

cat > /etc/sysconfig/network-scripts/ifcfg-${NETDEV} << EOF
DEVICE=${NETDEV}
ONBOOT=yes
BOOTPROTO=static
IPADDR=${IPADDR}
NETMASK=${NETMASK}
EOF

		sed "s/GATEWAY=/#GATEWAY=/g" /etc/sysconfig/network > /tmp/network && echo "GATEWAY=${GATEWAY}" >> /tmp/network && mv -f /tmp/network /etc/sysconfig/network
	else
		for NETDEV in ${NETCARD_DEVICE}
		do
			echo " ${GREEN}Network device ${MAGENTA}${NETDEV} ${GREEN}detected, DHCP broadcasting for IP.${NORMAL}"

cat > /etc/sysconfig/network-scripts/ifcfg-${NETDEV} << EOF
DEVICE=${NETDEV}
ONBOOT=yes
BOOTPROTO=dhcp
EOF

		done
	fi

fi

## === USB === ##
#if ! checkbootparam "nousb"
#then
#	modprobe usbcore >/dev/null 2>&1
#	FOUND_USB=""
#	FOUND_USB1=""
#	for u in usb-uhci usb-ohci
#	do
#		modprobe "$u" >/dev/null 2>&1 && FOUND_USB="yes"
#		if [ -n FOUND_USB ]
#		then
#			sed -e 's|@@USB@@|'"alias usb-controller $u"'|g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
#			mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
#		fi
#	done
#	for u1 in uhci-hcd ohci-hcd ehci-hcd
#	do
#		modprobe "$u1" >/dev/null 2>&1 && FOUND_USB1="yes"
#		if [ -n FOUND_USB1 ]
#		then
#			sed -e 's|@@USB1@@|'"alias usb-controller $u1"'|g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
#			mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
#		fi
#	done
#	if [ -n FOUND_USB -o -n FOUND_USB1 ]
#	then
#		echo " ${GREEN}USB found${NORMAL}"
#	else
#		echo " ${BLUE}Skipping USB detection${NORMAL}"
#		sed -e 's|@@USB@@||g' \
#		    -e 's|@@USB1@@||g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
#		mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
#	fi
#else
#	echo " ${BLUE}Skipping USB detection${NORMAL}"
#	sed -e 's|@@USB@@||g' \
#	    -e 's|@@USB1@@||g' /etc/modprobe.conf.in > /etc/modprobe.conf.tmp
#	mv -f /etc/modprobe.conf.tmp /etc/modprobe.conf.in
#fi

## === Mouse === ##
if [ -n "${MOUSE_FULLNAME}" -o -n "${MOUSE_DEVICE}" ]
then
	echo " ${GREEN}Mouse is ${YELLOW}${MOUSE_FULLNAME}${GREEN} at ${MAGENTA}${MOUSE_DEVICE}${NORMAL}"
fi

## === End === ##
cp -a /etc/modprobe.conf.in /etc/modprobe.conf
for tmpf in $(ls /etc/sysconfig/mol/*.tmp 2>/dev/null)
do
	mv -f ${tmpf%%.tmp} ${tmpf%%.tmp}.mol
	mv -f ${tmpf} ${tmpf%%.tmp}
done
echo "6" > /proc/sys/kernel/printk

