#!/bin/bash

## === Set Environment === ##
PATH=$PATH

## === Boot command line === ## 
CMDLINE="$(cat /proc/cmdline)"

## === Set functions === ##
getbootparam()
{
	case "$CMDLINE" in
		*\ $1=*) ;;
		$1=*) ;;
		*) return 1 ;;
	esac
	result="${CMDLINE##*$1=}"
	result="${result%%[     ]*}"
	echo "$result"
	return 0
}

checkbootparam()
{
	case "$CMDLINE" in
		*\ $1*) return 0 ;;
		$1*)    return 0 ;;
	esac
	return 1
}


## === Soundcard check === ##
NOAUDIO=""
if checkbootparam "noaudio"
then
	NOAUDIO="yes"
fi
SNDDEVNAME="/dev/snd \
	    /dev/audio \
	    /dev/dsp \
	    /dev/mixer"

for chkdev in ${SNDDEVNAME}
do
	if [ !  -e ${chkdev} ] && [ -z ${NOAUDIO} ]
	then	
		/sbin/MAKEDEV -d /dev ${chkdev#/dev/}
	fi
done

exit 0


