#!/bin/bash
#========================================================#
# Make One Linux -- mkinitrd-mol script
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
# This script makes initial ramdisk image for Make One Linux.
#

## === Set environment variable === ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## === Read molmakerc === ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## === Read options === ##
case "$*" in
	# Help
	*--help*)
	echo "Make One Linux -- mkinitrd-mol script"
	echo " (C)2005 Make One Linux Project <dgel@users.sourceforge.jp>"
	echo
	echo "This script makes initial ramdisk image for Make One Linux."
	echo "Usage: mkinitrd-mol [option]"
	echo "  --clean         : Clean up files made by this script"
	echo "  --help          : Show this help"
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	echo -n "${BLUE}Removing ${MAGENTA}initial ramdisk image${NORMAL}"
	rm -rf ${BUILD_ROOT}/initrd               && chkok
	rm -f  ${BUILD_ROOT}/initrd.img           && chkok
	rm -f  /boot/initrd-mol-${MOLVERSION}.img && chkok
	rm -rf ${BUILD_ROOT}/patch                && chkok
	rm -f  ${BUILD_ROOT}/mkinitrd-mol.flag    && chkok
	echo "${GREEN}Done${NORMAL}"
	exit 0 ;;
esac

## === Check flag === ##
if [ -f "${BUILD_ROOT}/mkinitrd-mol.flag" ]
then
	echo "Warning: First, please execute this script with --clean option."
	exit 1
fi


## === Start === ##
echo "${MAGENTA}mkinitrd-mol Starting${NORMAL}"

# Making initrd directory
echo -n "${BLUE}Making initrd directory${NORMAL}"
mkdir -p ${BUILD_ROOT}/initrd         && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/MOL     && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/proc    && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/exec    && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/sys     && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/sysroot && chkok || chkfail
ln -sf /MOL/bin  ${BUILD_ROOT}/initrd/bin  && chkok || chkfail
ln -sf /MOL/boot ${BUILD_ROOT}/initrd/boot && chkok || chkfail
ln -sf /MOL/lib  ${BUILD_ROOT}/initrd/lib  && chkok || chkfail
ln -sf /MOL/opt  ${BUILD_ROOT}/initrd/opt  && chkok || chkfail
ln -sf /MOL/sbin ${BUILD_ROOT}/initrd/sbin && chkok || chkfail
ln -sf /MOL/usr  ${BUILD_ROOT}/initrd/usr  && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Copying executable files to initrd directory
echo -n "${BLUE}Copying executable files to initrd directory${NORMAL}"
cp -a ${LIBEXECDIR}/linuxrc       ${BUILD_ROOT}/initrd/      && chkok || chkfail
cp -a ${LIBEXECDIR}/devcheck      ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
cp -a ${LIBEXECDIR}/autosetup-mol ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
cp -a ${LIBEXECDIR}/xsetup-mol    ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
cp -a ${DDCXINFO}                 ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
cp -a ${HWSETUP}                  ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
cp -a ${BUSYBOX}                  ${BUILD_ROOT}/initrd/exec/ && chkok || chkfail
ln -sf busybox-mol ${BUILD_ROOT}/initrd/exec/busybox && chkok || chkfail
touch ${BUILD_ROOT}/initrd/fastboot && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Making device files
echo -n "${BLUE}Making device files${NORMAL}"
[ -d ${BUILD_ROOT}/initrd/dev ] || mkdir -p ${BUILD_ROOT}/initrd/dev && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev console && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev fd      && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev hd      && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev loop    && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev mem     && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev null    && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev pcd     && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev random  && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev ram     && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev ramdisk && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev root    && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev scd     && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev sd      && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev ub      && chkok || chkfail
MAKEDEV -d ${BUILD_ROOT}/initrd/dev zero    && chkok || chkfail
ln -sf fd0 ${BUILD_ROOT}/initrd/dev/floppy  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/dev/pts       && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/dev/shm       && chkok || chkfail
rm -f ${BUILD_ROOT}/initrd/dev/tty*          && chkok || chkfail
rm -f ${BUILD_ROOT}/initrd/dev/sd[a-z][a-z]* && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Making directories and links to initrd/etc
echo -n "${BLUE}Making directories and links to initrd/etc${NORMAL}"
mkdir -p ${BUILD_ROOT}/initrd/etc             && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/X11         && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d        && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/init.d && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc0.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc1.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc2.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc3.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc4.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc5.d  && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/etc/rc.d/rc6.d  && chkok || chkfail
ln -s rc.d/init.d ${BUILD_ROOT}/initrd/etc/init.d && chkok || chkfail
ln -s rc.d/rc     ${BUILD_ROOT}/initrd/etc/rc     && chkok || chkfail
ln -s rc.d/rc0.d  ${BUILD_ROOT}/initrd/etc/rc0.d  && chkok || chkfail
ln -s rc.d/rc1.d  ${BUILD_ROOT}/initrd/etc/rc1.d  && chkok || chkfail
ln -s rc.d/rc2.d  ${BUILD_ROOT}/initrd/etc/rc2.d  && chkok || chkfail
ln -s rc.d/rc3.d  ${BUILD_ROOT}/initrd/etc/rc3.d  && chkok || chkfail
ln -s rc.d/rc4.d  ${BUILD_ROOT}/initrd/etc/rc4.d  && chkok || chkfail
ln -s rc.d/rc5.d  ${BUILD_ROOT}/initrd/etc/rc5.d  && chkok || chkfail
ln -s rc.d/rc6.d  ${BUILD_ROOT}/initrd/etc/rc6.d  && chkok || chkfail
ln -s rc.d/rc.sysinit ${BUILD_ROOT}/initrd/etc/rc.sysinit && chkok || chkfail
ln -s ../init.d/halt  ${BUILD_ROOT}/initrd/etc/rc.d/rc0.d/`basename /etc/rc.d/rc0.d/S??halt`   && chkok || chkfail
ln -s ../init.d/halt  ${BUILD_ROOT}/initrd/etc/rc.d/rc6.d/`basename /etc/rc.d/rc6.d/S??reboot` && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Copying some files from current system
echo -n "${BLUE}Copying some files from current system${NORMAL}"
cp -a /etc/auto.misc   ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok
cp -a /etc/filesystems ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/group       ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/gshadow     ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/inittab     ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/passwd      ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/resolv.conf ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/shadow      ${BUILD_ROOT}/initrd/etc/ >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Patching MOL configuration files
echo -n "${BLUE}Patching MOL configuration files${NORMAL}"
mkdir ${BUILD_ROOT}/patch >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/rc.d/rc.sysinit   ${BUILD_ROOT}/patch/rc.sysinit >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/rc.d/init.d/halt  ${BUILD_ROOT}/patch/halt       >/dev/null 2>&1 && chkok || chkfail
cp -a /etc/rc.d/init.d/netfs ${BUILD_ROOT}/patch/netfs      >/dev/null 2>&1 && chkok || chkfail
cp -a ${DATADIR}/mol/dependence/rc.sysinit.${DISTRIBUTION}.patch ${BUILD_ROOT}/patch/ >/dev/null 2>&1 && chkok || chkfail
cp -a ${DATADIR}/mol/dependence/halt.${DISTRIBUTION}.patch       ${BUILD_ROOT}/patch/ >/dev/null 2>&1 && chkok || chkfail
cp -a ${DATADIR}/mol/dependence/netfs.${DISTRIBUTION}.patch      ${BUILD_ROOT}/patch/ >/dev/null 2>&1 && chkok || chkfail
pushd ${BUILD_ROOT}/patch                >/dev/null 2>&1 && chkok || chkfail
patch < rc.sysinit.${DISTRIBUTION}.patch >/dev/null 2>&1 && chkok || chkfail
patch < halt.${DISTRIBUTION}.patch       >/dev/null 2>&1 && chkok || chkfail
patch < netfs.${DISTRIBUTION}.patch      >/dev/null 2>&1 && chkok || chkfail
mv rc.sysinit rc.sysinit.${DISTRIBUTION} && chkok || chkfail
mv halt halt.${DISTRIBUTION}             && chkok || chkfail
mv netfs netfs.${DISTRIBUTION}           && chkok || chkfail
popd                                     >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Copying MOL configuration files
echo -n "${BLUE}Copying MOL configuration files${NORMAL}"
cp -a ${DATADIR}/mol/dependence/fstab.${DISTRIBUTION}            ${BUILD_ROOT}/initrd/etc/fstab             >/dev/null 2>&1 && chkok
cp -a ${DATADIR}/mol/dependence/modprobe.conf.in.${DISTRIBUTION} ${BUILD_ROOT}/initrd/etc/modprobe.conf.in  >/dev/null 2>&1 && chkok
cp -a ${DATADIR}/mol/dependence/xorg.conf.in.${DISTRIBUTION}     ${BUILD_ROOT}/initrd/etc/X11/xorg.conf.in  >/dev/null 2>&1 && chkok
cp -a ${BUILD_ROOT}/patch/rc.sysinit.${DISTRIBUTION} ${BUILD_ROOT}/initrd/etc/rc.d/rc.sysinit   >/dev/null 2>&1 && chkok
cp -a ${BUILD_ROOT}/patch/halt.${DISTRIBUTION}       ${BUILD_ROOT}/initrd/etc/rc.d/init.d/halt  >/dev/null 2>&1 && chkok
cp -a ${BUILD_ROOT}/patch/netfs.${DISTRIBUTION}      ${BUILD_ROOT}/initrd/etc/rc.d/init.d/netfs >/dev/null 2>&1 && chkok
echo "${GREEN}Done${NORMAL}"

## Setting module list
MODULE_LIST=" \
	     cdrom.ko \
	     usbcore.ko \
	     ehci-hcd.ko \
	     uhci-hcd.ko \
	     ohci-hcd.ko \
	     usbhid.ko \
	     loop.ko \
	     ide-cd.ko \
	     isofs.ko \
	     nls_cp437.ko \
	     nls_utf8.ko \
	     fat.ko \
	     vfat.ko \
	     ntfs.ko \
	     jbd.ko \
	     ext3.ko \
	     reiserfs.ko \
	     unionfs.ko \
	     squashfs.ko"

SCSI_MODULE_LIST=" \
	     scsi_mod.ko \
	     sr_mod.ko \
	     aha1740.ko \
	     aha1542.ko \
	     aha152x.ko \
	     pas16.ko \
	     psi240i.ko \
	     qlogicfas.ko \
	     qlogicfs.ko \
	     seagate.ko \
	     t128.ko \
	     u14-34f.ko \
	     wd7000.ko \
	     aic7xxx.ko \
	     BusLogic.ko \
	     ncr53c8xx.ko \
	     NCR53c406a.ko \
	     initio.ko \
	     mptscsih.ko \
	     advansys.ko \
	     atp870u.ko \
	     dtc.ko \
	     eata.ko \
	     fdomain.ko \
	     gdth.ko \
	     megaraid.ko \
	     pci2220i.ko \
	     pci2000.ko \
	     qlogicisp.ko \
	     tmscsim.ko \
	     ultrastor.ko \
	     3w-xxxx.ko \
	     ataraid.ko \
	     silraid.ko \
	     medley.ko \
	     pdcraid.ko"

STORAGE_MODULE_LIST=" \
	     usb-storage.ko \
	     sd_mod.ko \
	     ieee1394.ko \
	     ohci1394.ko \
	     sbp2.ko"

# Setting additional module list
ADD_MODULE_LIST=$(mklist "$IN_MOD_LIST" 2>/dev/null)

# Making modules directories
echo -n "${BLUE}Making modules directories${NORMAL}"
mkdir -p ${BUILD_ROOT}/initrd/modules         && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/modules/scsi    && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/modules/storage && chkok || chkfail
mkdir -p ${BUILD_ROOT}/initrd/modules/add     && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Copying necessary kernel modules
echo -n "${BLUE}Copying necesarry kernel modules${NORMAL}"
for modules in ${MODULE_LIST}
do
	cp $(find /lib/modules/${KERNEL_RELEASE}/ -name "${modules}" 2>/dev/null) ${BUILD_ROOT}/initrd/modules/ >/dev/null 2>&1 && chkok
done
for modules in ${SCSI_MODULE_LIST}
do
	cp $(find /lib/modules/${KERNEL_RELEASE}/ -name "${modules}" 2>/dev/null) ${BUILD_ROOT}/initrd/modules/scsi/ >/dev/null 2>&1 && chkok
done
for modules in ${STORAGE_MODULE_LIST}
do
	cp $(find /lib/modules/${KERNEL_RELEASE}/ -name "${modules}" 2>/dev/null) ${BUILD_ROOT}/initrd/modules/storage/ >/dev/null 2>&1 && chkok
done
for modules in ${ADD_MODULE_LIST}
do
	cp $(find /lib/modules/${KERNEL_RELEASE}/ -name "${modules}" 2>/dev/null) ${BUILD_ROOT}/initrd/modules/add/ >/dev/null 2>&1 && chkok
done
echo "${GREEN}Done${NORMAL}"

## Making initial ramdisk image
echo -n "${BLUE}Making initial ramdisk image${NORMAL}"

# create ext2 filesystem to ram
dd if=/dev/zero of=/dev/ram bs=${INITRD_BS} count=${INITRD_COUNT} >/dev/null 2>&1 && chkok || chkfail
mke2fs -vm0 /dev/ram ${INITRD_COUNT}                              >/dev/null 2>&1 && chkok || chkfail

# copy contents of initrd.img to ram
[ -d ${BUILD_ROOT}/loop ] || mkdir -p ${BUILD_ROOT}/loop >/dev/null 2>&1 && chkok || chkfail
mount -t ext2 -o loop /dev/ram ${BUILD_ROOT}/loop        >/dev/null 2>&1 && chkok || chkfail
rmdir ${BUILD_ROOT}/loop/lost+found                      >/dev/null 2>&1 && chkok || chkfail
cp -a ${BUILD_ROOT}/initrd/* ${BUILD_ROOT}/loop/         >/dev/null 2>&1 && chkok || chkfail
umount ${BUILD_ROOT}/loop                                >/dev/null 2>&1 && chkok || chkfail
rmdir ${BUILD_ROOT}/loop                                 >/dev/null 2>&1 && chkok || chkfail

# make initrd.img
[ -d ${BUILD_ROOT}/var ] || mkdir -p ${BUILD_ROOT}/var >/dev/null 2>&1 && chkok || chkfail
[ -f ${BUILD_ROOT}/var/initrd ] && rm -f ${BUILD_ROOT}/var/initrd >/dev/null 2>&1 && chkok
dd if=/dev/ram of=${BUILD_ROOT}/var/initrd bs=${INITRD_BS} count=${INITRD_COUNT} >/dev/null 2>&1 && chkok || chkfail
gzip -v9 < ${BUILD_ROOT}/var/initrd > ${BUILD_ROOT}/initrd.img 2>&1 && chkok || chkfail
rm -rf ${BUILD_ROOT}/var >/dev/null 2>&1 && chkok || chkfail
[ x"${COPY_INITRD_TO_BOOTDIR}" = x"yes" ] && cp -a ${BUILD_ROOT}/initrd.img /boot/initrd-mol-${MOLVERSION}.img >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"


## === fin. === ##
touch ${BUILD_ROOT}/mkinitrd-mol.flag
echo "${MAGENTA}mkinitrd-mol Finished${NORMAL}"
exit 0

