#!/bin/bash
#========================================================#
# Make One Linux -- mksquashfs-mol script
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
# This script makes squashfs image for Make One Linux.
#


## === Environment Variable === ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## === Read molmakerc === ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## === Read options === ##
case "$*" in
	# Help
	*--help*)
	echo "Make One Linux -- mksquashfs-mol script"
	echo " (C)2005 Make One Linux Project <dgel@users.sourceforge.jp>"
	echo
	echo "This script makes squashfs image for Make One Linux."
	echo "Usage: mksquashfs-mol [option]"
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	echo -n "${BLUE}Removing ${MAGENTA}squashfs image${NORMAL}"
	rm -f ${BUILD_ROOT}/MOL >/dev/null 2>&1 && chkok
	rm -f ${BUILD_ROOT}/mksquashfs-mol.flag && chkok
	echo "${GREEN}Done${NORMAL}"
	exit 0 ;;
esac

## === Check flag === ##
if [ ! -f "${BUILD_ROOT}/mkinitrd-mol.flag" ]
then
	echo "Error: First, please execute mkinitrd-mol script."
	exit 1
fi
if [ -f "${BUILD_ROOT}/mksquashfs-mol.flag" ]
then
	echo "Warning: First, please execute this script with --clean option."
	exit 1
fi

## === Start === ##
echo "${MAGENTA}mksquashfs-mol Starting${NORMAL}"

# Set exclusion list
echo -n "${BLUE}Setting exclusion list${NORMAL}"
EXCLUDE_LIST=$(mklist "$EX_FILE_LIST" 2>/dev/null ; mklist "$EX_PKG_LIST" 2>/dev/null) && chkok || chkfail
EXCLUDE_LIST="/.autofsck /proc /sys /tmp /usr/tmp /var/tmp /var/log /dev /initrd /lost+found /mnt ${BUILD_ROOT} ${ISODIR} ${EXCLUDE_LIST}" && chkok || chkfail
[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_SQUASHFS="-e ${EXCLUDE_LIST}" && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Whether using squashfs or not
if [ "${ENABLE_SQUASHFS}" = "yes" ]
then
	echo "${BLUE}Making squashfs image${NORMAL}"
	echo -n "${CYAN}This may take a while${NORMAL}"
	${MKSQUASHFS} / ${BUILD_ROOT}/MOL ${EXCLUDE_FROM_SQUASHFS} >/dev/null 2>&1 && chkok || chkfail
	echo "${GREEN}Done${NORMAL}"
else
	echo "${CYAN}Skipping squashfs creation${NORMAL}"
	exit 0
fi


## === fin. === ##
touch ${BUILD_ROOT}/mksquashfs-mol.flag
echo "${MAGENTA}mksquashfs-mol Finished${NORMAL}"
exit 0

