#!/bin/bash
#========================================================#
# Make One Linux -- setup script
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
# This script starts up Make One Linux setup
#

## === Environment Variable === ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## === Read molmakerc === ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## === Read options === ##
case "$*" in
	# Help
	*--help*)
	echo "Make One Linux -- molmake script"
	echo " (C)2005 Make One Linux Project <dgel@users.sourceforge.jp>"
	echo
	echo " Usage: molmake <option>"
	echo
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	${SBINDIR}/mkisofs-mol --clean
	${SBINDIR}/mksquashfs-mol --clean
	${SBINDIR}/mkinitrd-mol --clean
	exit 0 ;;
esac


## === Start === ##
echo "${MAGENTA}<-- ${RED}Make ${CYAN}One ${GREEN}Linux ${BLUE}Setup Starting ${MAGENTA}-->${NORMAL}"
echo ""
echo ""

# Execute script files
echo "${MAGENTA}<- ${BLUE}Stage 1 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mkinitrd-mol
echo ""
echo "${MAGENTA}<- ${BLUE}Stage 2 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mksquashfs-mol
echo ""
echo "${MAGENTA}<- ${BLUE}Stage 3 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mkisofs-mol
echo ""
echo ""

## === fin. === ##
echo "${MAGENTA}<-- ${RED}Make ${CYAN}One ${GREEN}Linux ${BLUE}Setup Finished ${MAGENTA}-->${NORMAL}"
exit 0

