#!/exec/busybox-mol ash
#========================================================#
# Make One Linux General Startup Script 2
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
#


## === Define === ##
looproot=/MOL/MOL     # Compressed Image File
loopswap=/MOL/mol.swp # Swap Image File
moddir=/modules       # Kernel Modules Directory
sysdir=/MOL           # Hole System Directory
MOLFLAG=/MOL/MOLFLAG  # Mark File When searching MOL Media
MOLVERSION=/etc/mol/VERSION # Make One Linux Version File
PATH="/exec:/sbin:/bin:/usr/sbin:/usr/bin:." # Command Search Path
export PATH

# set Color
RESET="]R"       # Reset fb color mode
CRE="
[K"       # Erase to end of line
CLEAR="c"        # Clear and reset Screen
NORMAL="[0;39m"  # Normal Color
RED="[1;31m"     # Failure or error message
GREEN="[1;32m"   # Success message
YELLOW="[1;33m"  # Descriptions
BLUE="[1;34m"    # System message
MAGENTA="[1;35m" # Found devices or drivers
CYAN="[1;36m"    # Questions
WHITE="[1;37m"   # Hint


## === Alias for Busybox === ##
alias [='busybox-mol ['
alias ash='busybox-mol ash'
alias cat='busybox-mol cat'
alias chroot='busybox-mol chroot'
alias echo='busybox-mol echo'
alias insmod='busybox-mol insmod'
alias losetup='busybox-mol losetup'
alias lsmod='busybox-mol lsmod'
alias mount='busybox-mol mount'
alias pivot_root='busybox-mol pivot_root'
alias rmmod='busybox-mol rmmod'
alias sh='busybox-mol sh'
alias test='busybox-mol test'
alias umount='busybox-mol umount'


## === Function === ##
# Mount Function
pmount()
{
	BUILTIN_FS="iso9660 ext3 vfat ntfs ext2 reiserfs"
	for fs in ${BUILTIN_FS}
	do
		if (test -b "$1" && mount -t $fs $3 $1 $2 >/dev/null 2>&1)
		then
			FOUND_FS="$fs"
			return 0
		fi
	done
	echo "mount fail"
	return 1
}

# Check Boot Parameter
checkbootparam()
{
	case "$CMDLINE" in
		*\ $1*) return 0 ;;
		$1*)    return 0 ;;
	esac
	return 1
}

# Check Module to Load
chkinsmod()
{
	if [ -f "$1" ]
	then
		insmod "$*" >/dev/null 2>&1
	fi
}

# Ask user for modules
askmodules()
{
	TYPE="$1"; shift
	echo "${BLUE}${TYPE} modules available:${WHITE}"
	FLAG=""
	for m in "$@"
	do
		if test -f "${moddir}/scsi/$m"; then
			[ -z "$FLAG" ] && { echo -n "	$m"; FLAG="on"; } || { echo "		$m"; FLAG=""; }
		fi
	done
	[ -n "$FLAG" ] && echo
	echo "${CYAN}Load ${TYPE} Modules?${NORMAL}"
	echo "${CYAN}[Enter full filename(s) (space-separated), Return for autoprobe, ${WHITE}n${CYAN} for none] ${NORMAL}"
	echo -n "${CYAN}insmod module(s)> ${NORMAL}"
	read MODULES
	case "$MODULES" in n|N) MODULES=""; ;; y|"") MODULES="$*"; ;; esac
}

# Try to load the given modules (full path or current directory)
loadmodules()
{
	TYPE="$1"; shift
	test -n "$INTERACTIVE" && echo "6" > /proc/sys/kernel/printk
	for i in "$@"
	do
		echo -n "${CRE}${BLUE}Probing ${TYPE}... ${MAGENTA}$i${NORMAL}"
		if test -f "${moddir}/scsi/$i" && insmod -f ${moddir}/scsi/$i >/dev/null 2>&1
		then
			case "$TYPE" in scsi|SCSI) FOUND_SCSI="yes"; ;; esac
		fi
	done
	test -n "$INTERACTIVE" && echo "0" > /proc/sys/kernel/printk
	echo -n "${CRE}"
}

# Mount modules disk
mountmodules()
{
	TYPE="$1"; shift
	echo -n "${CRE}${CYAN}Please insert ${TYPE} modules disk and hit Return. ${NORMAL}"
	read a
	echo -n "${CRE}${BLUE}Mounting ${TYPE} modules disk... ${NORMAL}"
	if pmount /dev/fd0 ${moddir}/scsi "-o ro"; then
		echo "${GREEN}OK.${NORMAL}"
		return 0
	fi
	echo "${RED}NOT FOUND.${NORMAL}"
	return 1
}

# Unmount modules disk
umountmodules()
{
	TYPE="$1"; shift
	echo -n "${CRE}${BLUE}Unmounting ${TYPE} modules disk... ${NORMAL}"
	umount ${moddir}/scsi 2>/dev/null
	echo "${GREEN}DONE.${NORMAL}"
}

# Create mtab and fstab
mfstab()
{
cat > /etc/fstab << EOF
/dev/root	/		ext2	defaults			0 0
none		/sys		sysfs	defaults			0 0
none		/proc		proc	defaults			0 0
none		/dev/pts	devpts	defaults			0 0
/dev/fd0	/mnt/floppy	auto	users,noauto,exec,iocharset=utf8	0 0
EOF
cat > /etc/mtab << EOF
/dev/root / ext2 rw 0 0
EOF

if [ -n "${OVERLAY}" -a -z "${COPYTO}" ]
then
cat > /etc/fstab.overlay << EOF
none		/sys		sysfs	defaults			0 0
none		/proc		proc	defaults			0 0
none		/dev/pts	devpts	defaults			0 0
/dev/fd0	/mnt/floppy	auto	users,noauto,exec,iocharset=utf8	0 0
EOF
cat > /etc/mtab.overlay << EOF
EOF
fi
}

# Make Daemons links to ramdisk
lnkdaemon()
{
	DAEMONNAME=$1
	if [ -f "${sysdir}/etc/rc.d/init.d/${DAEMONNAME}" -a -f "/etc/rc.d/init.d/${DAEMONNAME}" ]
	then
		cnt="0"
		while [ "${cnt}" -le 6 ]
		do
			DAEMONLINK=$(find ${sysdir}/etc/rc.d/rc${cnt}.d -name "?[0-9][0-9]${DAEMONNAME}" 2>/dev/null)
			DAEMONLINK=${DAEMONLINK##*${sysdir}}
			ln -sf ../init.d/${DAEMONNAME} ${DAEMONLINK}
			cnt=$(expr ${cnt} + 1 2>/dev/null)
			done
		unset cnt
		unset DAEMONNAME
		unset DAEMONLINK
	fi
}

# Make Symlinks to ramdisk
mklnk()
{
	LINKFROM="$1"
	LINKTO="$2"
	LS="${sysdir}/bin/ls"
	LN="${sysdir}/bin/ln"
	for lnk in $($LS -A "${LINKFROM}"); do
		$LN -sf "${LINKFROM}""$lnk" "${LINKTO}" 2>/dev/null
	done
	unset LINKFROM
	unset LINKTO
	unset lnk
}

# Emergency Shell
startash()
{
	echo "${CRE}${RED}Can't find ${MAGENTA}Make One Linux System${RED}, sorry.${NORMAL}"
	echo "${RED}Dropping you to a (very limited) shell.${NORMAL}"
	echo "${RED}Press reset button to quit.${NORMAL}"
	echo

	PS1=" mod # "
	export PS1
	echo "6" > /proc/sys/kernel/printk
	trap 1 2 3 15

	exec /exec/busybox ash
}


## === Init === ##
trap "" 1 2 3 15                       # Don't allow interrupt signals
exec >/dev/console </dev/console 2>&1  # Clean I/O
umask 022                              # Permittion mask

echo
echo "${RED}Make ${CYAN}One ${MAGENTA}Linux ${WHITE}Start ${YELLOW}!!${NORMAL}"

mount -t proc /proc /proc              # Mount proc filesystem
echo "0" > /proc/sys/kernel/printk     # Disable kernel messages


## === Check Boot Command Line === ##
echo "<< Checking Boot Command Line >>"
CMDLINE="$(cat /proc/cmdline)"
if (checkbootparam "boot=rom")   ; then boot="-o ro"        ; fi
if (checkbootparam "mod_dir=")   ; then looproot="$mod_dir" ; fi
if (checkbootparam "overlay")    ; then OVERLAY="yes"       ; fi
if (checkbootparam "skelhome")   ; then SKELHOME="yes"      ; fi
if (checkbootparam "from=")      ; then BOOTFROM="$from"    ; fi
if (checkbootparam "expert")     ; then INTERACTIVE="yes"   ; :>/interactive   ; fi
if (checkbootparam "addmodules") ; then ADDMODULES="yes"    ; fi
if (checkbootparam "noscsi")     ; then NOSCSI="yes"        ; fi
if (checkbootparam "nousb")      ; then NOUSB2="yes"        ; fi
if (checkbootparam "nofirewire") ; then NOFIREWIRE="yes"    ; fi
if (checkbootparam "noraid")     ; then NORAID="yes"        ; fi
if (checkbootparam "nodma")      ; then NODMA="yes"         ; fi
if (checkbootparam "toram")      ; then COPYTO="yes"        ; COPYTORAM="yes"  ; fi
if (checkbootparam "tohd=")      ; then COPYTO="yes"        ; COPYTOHD="$tohd" ; fi


## === Load Kernel Modules === ##
echo "<< Loading Modules >>"
chkinsmod ${moddir}/scsi/scsi_mod.*o
chkinsmod ${moddir}/cdrom.*o
chkinsmod ${moddir}/scsi/sr_mod.*.o
chkinsmod ${moddir}/usbcore.*o
[ -z "${NOUSB2}" ] && chkinsmod ${moddir}/ehci-hcd.*o
chkinsmod ${moddir}/uhci-hcd.*o
chkinsmod ${moddir}/ohci-hcd.*o
chkinsmod ${moddir}/storage/usb-storage.*o
chkinsmod ${moddir}/storage/sd_mod.*o
chkinsmod ${moddir}/usbhid.*o
chkinsmod ${moddir}/loop.*o
chkinsmod ${moddir}/ide-cd.*o
chkinsmod ${moddir}/isofs.*o
chkinsmod ${moddir}/nls_cp437.*o
chkinsmod ${moddir}/nls_utf8.*o
chkinsmod ${moddir}/fat.*o
chkinsmod ${moddir}/vfat.*o
chkinsmod ${moddir}/ntfs.*o
chkinsmod ${moddir}/jbd.*o
chkinsmod ${moddir}/ext3.*o
chkinsmod ${moddir}/reiserfs.*o


# Check for SCSI
if [ -z "$NOSCSI" ]
then
	echo -n "${CRE}${BLUE}Checking for SCSI...${NORMAL}"
	if [ -n "$INTERACTIVE" ]
	then
		askmodules SCSI $(cd ${moddir}/scsi; echo *.*o)
		[ -n "$MODULES" ] && loadmodules SCSI $MODULES
	else
		chkinsmod ${moddir}/scsi/aha1740.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/aha1542.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/aha152x.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/pas16.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/psi240i.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/qlogicfas.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/qlogicfc.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/seagate.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/t128.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/u14-34f.*o && FOUND_SCSI="yes"
		chkinsmod ${moddir}/scsi/wd7000.*o && FOUND_SCSI="yes"
		PROCPCI="`cat /proc/pci 2>/dev/null`"
		case "$PROCPCI" in *[Aa][Ii][Cc]-|*[Aa][Hh][Aa]-*)
			chkinsmod ${moddir}/scsi/aic7xxx.*o    && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Bb][Uu][Ss][Ll][Oo][Gg][Ii][Cc]*)
			chkinsmod ${moddir}/scsi/BusLogic.*o   && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *53[Cc]8*)
			chkinsmod ${moddir}/scsi/ncr53c8xx.*o  && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *53[Cc]406*)
			chkinsmod ${moddir}/scsi/NCR53c406a.*o && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Ii][Nn][Ii][Tt][Ii][Oo]\ *|*[Ii][Nn][Ii]-[Aa]100[Uu]2[Ww]*)
			chkinsmod ${moddir}/scsi/initio.*o     && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Mm][Pp][Tt]*[Ss][Cc][Ss][Ii]*)
			chkinsmod ${moddir}/scsi/mptscsih.*o   && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Aa][Dd][Vv][Aa][Nn][Cc][Ee][Dd]\ [Ss][Yy][Ss]*)
			chkinsmod ${moddir}/scsi/advansys.*o   && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Aa][Tt][Pp]8|*[Aa][Ee][Cc]6*)
			chkinsmod ${moddir}/scsi/atp870u.*o    && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Dd][Tt][Cc]*)
			chkinsmod ${moddir}/scsi/dtc.*o        && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Ee][Aa][Tt][Aa]*)
			chkinsmod ${moddir}/scsi/eata.*o       && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Ff]*[Dd][Oo][Mm][Aa][Ii][Nn]*)
			chkinsmod ${moddir}/scsi/fdomain.*o    && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Gg][Dd][Tt]\ *)
			chkinsmod ${moddir}/scsi/gdth.*o       && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Mm][Ee][Gg][Aa][Rr][Aa][Ii][Dd]*)
			chkinsmod ${moddir}/scsi/megaraid.*o   && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Pp][Cc][Ii]-22*)
			chkinsmod ${moddir}/scsi/pci2220i.*o   && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Pp][Cc][Ii]-2000*)
			chkinsmod ${moddir}/scsi/pci2000.*o    && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Qq][Ll][Oo][Gg][Ii][Cc]*)
			chkinsmod ${moddir}/scsi/qlogicisp.*o  && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *53[Cc]974*)
			chkinsmod ${moddir}/scsi/tmscsim.*o    && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *[Uu][Ll][Tt][Rr][Aa][Ss][Tt][Oo][Rr]*)
			chkinsmod ${moddir}/scsi/ultrastor.*o  && FOUND_SCSI="yes" ;; esac
		case "$PROCPCI" in *3[Ww][Aa][Rr][Ee]*)
			chkinsmod ${moddir}/scsi/3w-xxxx.*o    && FOUND_SCSI="yes" ;; esac
	fi
	echo -n "${CRE}"
fi


# Check for IDE-Raid devices
if [ -z "$NORAID" ]
then
	echo -n "${CRE}${BLUE}Checking for RAID...${NORMAL}"
	FLAG=""
	[ -z "$FLAG" ] && chkinsmod ${moddir}/scsi/ataraid.*o || FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/scsi/silraid.*o || FLAG="on"
	[ -n "$FLAG" ] && chkinsmod ${moddir}/scsi/medley.*o  && FLAG=""
	[ -n "$FLAG" ] && chkinsmod ${moddir}/scsi/pdcraid.*o
	echo -n "${CRE}"
fi


# Check for Firewire
if [ -z "$NOFIREWIRE" ]
then
	echo -n "${CRE}${BLUE}Checking for Firewire...${NORMAL}"
	FLAG=""
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/ieee1394.*o || FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/ohci1394.*o || FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/sbp2.*o sbp2_serialize_io=1
	echo -n "${CRE}"
fi


# Check for Additional Modules
if [ -n "$ADDMODULES" ]
then
	chkinsmod ${moddir}/add/*.*o
fi


# Check for misc modules in expert mode
if [ -n "$INTERACTIVE" ]
then
	another=""
	answer=""
	while [ "$answer" != "n" -a "$answer" != "N" ]
	do
		echo -n "${CYAN}Do you want to load additional modules from $another floppy disk? [${WHITE}Y${CYAN}/n] ${NORMAL}"
		another="another"
		read answer
		case "$answer" in n*|N*) break; ;; esac
		if mountmodules new; then
			askmodules new $(cd ${moddir}/scsi; echo *.*o)
			[ -n "$MODULES" ] && loadmodules new $MODULES
			umountmodules current
		fi
	done
fi


## === Mount Device === ##
echo "<< Mounting Make One Linux System >>"

# Enable DMA
if [ -z "$NODMA" ]
then
	for d in $(cd /proc/ide 2>/dev/null && echo hd[a-z]); do
		if [ -d "/proc/ide/$d" ]; then
			MODEL="$(cat /proc/ide/$d/model 2>/dev/null)"
			[ -z "$MODEL" ] && MODEL="[GENERIC IDE DEVICE]"
			echo "${BLUE}Enabling DMA acceleration for: ${MAGENTA}$d 	${YELLOW}[${MODEL}]${NORMAL}"
			echo "using_dma:1" >/proc/ide/$d/settings
		fi
	done
fi


# Try to find CD/DVD Media
loop0=/dev/loop0
loop1=/dev/loop1

# Set Device Special Files for Searching
if [ -z "$BOOTFROM" ]
then
	DEVICES="/dev/hd? /dev/pcd?"
	[ -f "/proc/scsi/scsi" ] && FOUND_SCSI="yes"
	[ -n "$FOUND_SCSI" ] && DEVICES="/dev/scd? /dev/scd?? $DEVICES"
	[ -n "$FOUND_SCSI" -a -z "$NOSCSI" ] && DEVICES="$DEVICES /dev/sd?[1-9] /dev/sd?[1-9][0-9]"
	DEVICES="$DEVICES /dev/ub?[1-9] /dev/ub?[1-9][0-9] /dev/hd?[1-9] /dev/hd?[1-9][0-9]"
else
	DEVICES="$BOOTFROM"
fi

# Mount MOL System
for i in $DEVICES
do
	echo -n "${CRE}${BLUE}Looking for CD/DVD Meida in: ${MAGENTA}$i${NORMAL}   "
	if pmount $i /sysroot "${boot}" >/dev/null 2>&1
	then
		# for Boot from Raw File System
		if [ -f "/sysroot${MOLVERSION}" ]
		then
			echo -n "${CRE} ${GREEN}Accessing Make One Linux Raw File System at ${MAGENTA}$i${GREEN}...${NORMAL}"
			FOUND_MOL="$i"
			break
		fi
		# for Boot from Image File System
		if [ -f "/sysroot${MOLFLAG}" ]
		then
			echo -n "${CRE} ${GREEN}Accessing Make One Linux Image File System at ${MAGENTA}$i${GREEN}...${NORMAL}"
			FOUND_MOL="$i"
			break
		fi
		umount /sysroot
	fi
done

# Raw File System Mode
if [ -f "/sysroot${MOLVERSION}" ]
then
	# Copy Raw to RAM/HD Mode
	if [ -n "${COPYTO}" ]
	then
		echo
		echo -n "${CRE} ${GREEN}Copying SYSTEM to "
		if [ -n "${COPYTORAM}" ]
		then
			echo -n "${MAGENTA}ramdisk${GREEN}... Please be patient.${NORMAL}"
			/bin/mount -t tmpfs -o size=500M /dev/shm ${sysdir}
			/bin/cp -a /sysroot/.[^.]* ${sysdir}
			/bin/cp -a /sysroot/* ${sysdir}
		elif [ -n "${COPYTOHD}" ]
		then
			echo -n "${MAGENTA}${COPYTOHD}${GREEN}... Please be patient.${NORMAL}"
			if pmount ${COPYTOHD} ${sysdir} >/dev/null 2>&1
			then
				/bin/cp -a /sysroot/.[^.]* ${sysdir}
				/bin/cp -a /sysroot/* ${sysdir}
			else
				echo "${CRE} ${RED}Copying failed. /dev/$COPYTOHD is not mountable. ${NORMAL}"
				echo
				startash
			fi
		fi
		umount /sysroot
		mfstab

cat > /etc/fstab.in << EOF
/dev/shm	${sysdir}	tmpfs	defaults				0 0
/dev/shm	/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.in << EOF
/dev/shm ${sysdir} tmpfs rw 0 0
/dev/shm /ramdisk tmpfs rw 0 0
EOF

		rmdir /sysroot
		ln -s ${sysdir} /sysroot

	# Raw Read-Only Mode
	elif [ -n "${boot}" ]
	then
		umount /sysroot
		pmount "${FOUND_MOL}" "${sysdir}" "-o ro" || startash
		rmdir /sysroot
		ln -s ${sysdir} /sysroot
		mfstab

cat > /etc/fstab.in << EOF
${FOUND_MOL}	${sysdir}		${FOUND_FS}	ro					0 0
/dev/shm	/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.in << EOF
${FOUND_MOL} ${sysdir} ${FOUND_FS} ro 0 0
/dev/shm /ramdisk tmpfs rw 0 0
EOF

		if [ -n "${OVERLAY}" ]
		then

cat > /etc/fstab.overlay.in << EOF
/MOL-		/		unionfs	defaults				0 0
${FOUND_MOL}	/initrd${sysdir}	${FOUND_FS}	ro					0 0
/dev/shm	/initrd/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.overlay.in << EOF
/MOL- / unionfs rw,dirs=/initrd/ramdisk/MOL+=rw:/initrd/MOL=ro,debug=0,err=tryleft,delete=all,copyup=preserve,setattr=left 0 0
${FOUND_MOL} /initrd${sysdir} ${FOUND_FS} ro 0 0
/dev/shm /initrd/ramdisk tmpfs rw 0 0
EOF

		fi

	# Raw Readable/Writable Mode
	else
		umount /sysroot
		pmount $FOUND_MOL /sysroot "-o ro" >/dev/null 2>&1
		echo 0x100 > /proc/sys/kernel/real-root-dev
		umount /proc

		pivot_root /sysroot /sysroot/initrd

		echo
		echo "${CRE}${BLUE}Starting init process.${NORMAL}"
		exit 0
	fi

# Image File System Mode
elif [ -f "/sysroot${MOLFLAG}" ]
then
	# Copy Image to RAM/HD Mode
	if [ -n "${COPYTO}" ]
	then
		echo
		echo -n "${CRE} ${GREEN}Copying SYSTEM to "
		/bin/mkdir /system
		if [ -n "${COPYTORAM}" ]
		then
			echo -n "${MAGENTA}ramdisk${GREEN}... Please be patient.${NORMAL}"
			/bin/mount -t tmpfs -o size=500M /dev/shm /system
			/bin/mkdir /system/MOL
			/bin/cp -a /sysroot${looproot} /system/MOL/
		elif [ -n "${COPYTOHD}" ]
		then
			echo -n "${MAGENTA}${COPYTOHD}${GREEN}... Please be patient.${NORMAL}"
			if pmount ${COPYTOHD} /system >/dev/null 2>&1
			then
				/bin/cp -a /sysroot/MOL /system
			else
				echo "${CRE} ${RED}Copying failed. /dev/$COPYTOHD is not mountable. ${NORMAL}"
				echo
				startash
			fi
		fi
		umount /sysroot
		insmod ${moddir}/squashfs.*o >/dev/null 2>&1
		losetup ${loop0} /system${looproot} >/dev/null 2>&1
		mount -t squashfs -o ro ${loop0} ${sysdir} >/dev/null 2>&1 || FOUND_MOL=""
		loop="${loop0}"
		if [ -z "${FOUND_MOL}" ]; then
			losetup ${loop0} /system${looproot} >/dev/null 2>&1
			pmount ${loop0} ${sysdir} "-o ro" || startash
			FOUND_MOL="${i}"
			loop="${loop0}"
		fi
		mfstab

cat > /etc/fstab.in << EOF
/dev/shm	/system		tmpfs	defaults				0 0
${loop}		${sysdir}		squashfs	ro					0 0
/dev/shm	/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.in << EOF
/dev/shm /system tmpfs rw 0 0
${loop} ${sysdir} squashfs ro 0 0
/dev/shm /ramdisk tmpfs rw 0 0
EOF

		rmdir /sysroot
		ln -s /system /sysroot

	# Image Read-Only Mode
	elif [ -n "${boot}" ]
	then
		insmod ${moddir}/squashfs.*o >/dev/null 2>&1
		losetup ${loop0} /sysroot${looproot} >/dev/null 2>&1
		mount -t squashfs -o ro ${loop0} ${sysdir} >/dev/null 2>&1 || FOUND_MOL=""
		loop="${loop0}"
		if [ -z "${FOUND_MOL}" ]; then
			losetup ${loop0} /sysroot${looproot} >/dev/null 2>&1
			pmount ${loop0} ${sysdir} "-o ro" || startash
			FOUND_MOL="${i}"
			loop="${loop0}"
		fi
		mfstab

cat > /etc/fstab.in << EOF
${FOUND_MOL}	/sysroot	${FOUND_FS}	ro					0 0
${loop}		${sysdir}		squashfs	ro					0 0
/dev/shm	/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.in << EOF
${FOUND_MOL} /sysroot ${FOUND_FS} ro 0 0
${loop} ${sysdir} squashfs ro 0 0
/dev/shm /ramdisk tmpfs rw 0 0
EOF

		if [ -n "${OVERLAY}" ]
		then

cat > /etc/fstab.overlay.in << EOF
/MOL-		/		unionfs	defaults				0 0
${FOUND_MOL}	/initrd/sysroot	${FOUND_FS}	ro					0 0
${loop}	/initrd${sysdir}		squashfs	ro					0 0
/dev/shm	/initrd/ramdisk	tmpfs	defaults				0 0
EOF
cat > /etc/mtab.overlay.in << EOF
/MOL- / unionfs rw,dirs=/initrd/ramdisk/MOL+=rw:/initrd/MOL=ro,debug=0,err=tryleft,delete=all,copyup=preserve,setattr=left 0 0
${FOUND_MOL} /initrd/sysroot ${FOUND_FS} ro 0 0
${loop} /initrd${sysdir} squashfs ro 0 0
/dev/shm /initrd/ramdisk tmpfs rw 0 0
EOF

		fi

	# Image Readable/Writable Mode
	else
		losetup ${loop0} /sysroot${looproot} >/dev/null 2>&1
		pmount ${loop0} ${sysdir} "-o ro"
		losetup ${loop1} /sysroot${loopswap} >/dev/null 2>&1
		echo 0x100 > /proc/sys/kernel/real-root-dev
		umount /proc

		pivot_root ${sysdir} ${sysdir}/initrd

		echo
		echo "${CRE}${BLUE}Starting init process.${NORMAL}"
		exit 0
	fi

# Mount Failed Mode
else
	echo "${CRE}<< Mount Failed !! >>"
	echo
	startash
fi


## === Copy Library Cache === ##
cat ${sysdir}/etc/ld.so.cache > /etc/ld.so.cache
echo

## === Enable Kernel Messages === ##
echo "6" > /proc/sys/kernel/printk

## === Unalias for Busybox === ##
unalias [
unalias ash
unalias cat
unalias chroot
unalias echo
unalias insmod
unalias losetup
unalias lsmod
unalias mount
unalias pivot_root
unalias rmmod
unalias sh
unalias test
unalias umount


## === Memory Information === ##
FOUNDMEM="$(awk '/MemTotal/{print $2}' /proc/meminfo)"
TOTALMEM="$(awk 'BEGIN{m=0};/MemFree|Cached/{m+=$2};END{print m}' /proc/meminfo)"
echo "${CRE}${BLUE}Total memory found: ${YELLOW}${FOUNDMEM} ${BLUE}KB${NORMAL}"

# Calc RAM Size
MINSIZE=2000  # Minimum size of additional ram  partitions
MINLEFT=16000 # At least this much memory minus 30% should remain when home and var are full.
MAXSIZE="$(expr $TOTALMEM - $MINLEFT)" # Maximum ramdisk size
RAMSIZE="$(expr $TOTALMEM / 5)"        # Default ramdisk size

## === Create RAMDISK === ##
if [ -n "$TOTALMEM" -a "$TOTALMEM" -gt "$MINLEFT" ]
then
	mkdir -p /ramdisk
	[ -z "$RAMSIZE" ] && RAMSIZE=100000
	RAMSIZE=$(expr $RAMSIZE \* 4)
	echo -n "${CRE}${BLUE}Creating ${YELLOW}/ramdisk ${BLUE}(dynamic size=${YELLOW}${RAMSIZE}${BLUE}kb) on ${MAGENTA}shared memory${BLUE}...${NORMAL}"

	/bin/mount -t tmpfs -o "size=${RAMSIZE}k" /dev/shm /ramdisk
	chmod 1755 /ramdisk
	mkdir -p -m 0750 /ramdisk/root
	mkdir -p -m 1777 /ramdisk/tmp
	mkdir -p /ramdisk/home /ramdisk/var
	mv /etc /ramdisk
	rm -Rf /root
	ln -s /ramdisk/root /ramdisk/home /ramdisk/var /ramdisk/tmp /ramdisk/etc /
	echo "${BLUE}Done.${NORMAL}"
elif [ -z "$TOTALMEM" ]
then
	echo "${CRE}<< Can't Get Memory Information. Failed !! >>"
	echo
	echo "${CRE}${CYAN}Please hit Return to start ash.${NORMAL}"
	read a
	startash
else
	echo "${CRE}<< Your Computer does NOT have enough Memory Size. Failed !! >>"
	echo
	echo "${CRE}  Detected Memory Size : ${TOTALMEM}kb"
	echo "${CRE}  Required Memory Size : ${MINLEFT}kb"
	echo
	echo "${CRE}${CYAN}Please hit Return to start ash.${NORMAL}"
	read a
	startash
fi


## === Setup Overlaying System === ##
if [ -n "${OVERLAY}" -a -n "${boot}" -a -z "${COPYTO}" ]
then
	echo "<< Setup Overlaying System >>"
	cat < /etc/fstab.in >> /etc/fstab
	cat < /etc/mtab.in >> /etc/mtab
	/bin/mount -o remount,rw /sysroot
	mkdir /ramdisk/MOL+ /MOL-
	ln -s /ramdisk/MOL+ /MOL+
	mv /ramdisk/home /ramdisk/MOL+/
	mv /ramdisk/root /ramdisk/MOL+/
	modprobe unionfs
	/bin/mount -t unionfs -o dirs=/MOL+=rw:${sysdir}=ro /MOL- /MOL-

	# create directories
	mkdir -p /MOL-/var/lib /MOL-/var/lock /MOL-/var/log /MOL-/var/nis \
		/MOL-/var/preserve /MOL-/var/run /MOL-/var/tmp /MOL-/var/opt \
		/MOL-/var/spool/cups/tmp \
		/MOL-/mnt/floppy \
		/MOL-/MOL /MOL-/lost+found \
		/MOL-/initrd /MOL-/proc /MOL-/dev /MOL-/sys /MOL-/tmp \
		/MOL-/etc/sysconfig /MOL-/etc/X11 /MOL-/etc/cups
	
	# change original file to this
	#cp -a /etc/inittab /MOL-/etc/
	cp -a /etc/rc.d/rc.sysinit /MOL-/etc/rc.d/
	cp -a /etc/rc.d/init.d/halt /MOL-/etc/rc.d/init.d/
	cp -a /etc/rc.d/init.d/netfs /MOL-/etc/rc.d/init.d/
	# change original file to this after finishing linuxrc script
	cp -a /etc/X11/xorg.conf.in /MOL-/etc/X11/
	cp -a /etc/modprobe.conf.in /MOL-/etc/
	# for Overlaying System's fstab and mtab
	cp -a /etc/fstab.overlay /MOL-/etc/fstab
	cp -a /etc/fstab.overlay.in /MOL-/etc/fstab.in
	cp -a /etc/mtab.overlay /MOL-/etc/mtab
	cp -a /etc/mtab.overlay.in /MOL-/etc/mtab.in
	# other necessary files
	cp -a /exec /MOL-/
	cp -a /dev/console /MOL-/dev/

	/bin/mount --bind /MOL /MOL-/MOL

	echo "/sbin/modprobe" > /proc/sys/kernel/modprobe
	echo "0x100" > /proc/sys/kernel/real-root-dev
	umount /proc
	rm -f /linuxrc

	pivot_root /MOL- /MOL-/initrd
	chmod 1777 /tmp /var/tmp
	chmod 0755 /etc/sysconfig
	chkconfig --level 0123456 kudzu off
	:> /var/run/utmp
	:> /var/run/wtmp
	touch /fastboot
	exit 0
fi


## === Create /home and /root Directories === ##
echo -n "${CRE}${BLUE}Creating ${YELLOW}/home ${BLUE}and ${YELLOW}/root ${BLUE}directories...${NORMAL}"

for u in $(ls -A ${sysdir}/home)
do
	if [ "$u" = "httpd" ]
	then
		ln -s ${sysdir}/home/httpd /home/httpd
	elif [ -n "${SKELHOME}" ]
	then
		USER_D=$(grep "/home/$u" /etc/passwd | cut -d: -f1 2>/dev/null)
		GROUP_D=$(id -gn ${USER_D} 2>/dev/null)
		mkdir -p -m 700 /home/$u
		for f in $(ls -A ${sysdir}/etc/skel)
		do
			cp -a ${sysdir}/etc/skel/$f /home/$u
		done
		unset f
		chown -Rf ${USER_D}:${GROUP_D} /home/$u
	else
		USER_D=$(grep "/home/$u" /etc/passwd | cut -d: -f1 2>/dev/null)
		GROUP_D=$(id -gn ${USER_D} 2>/dev/null)
		mkdir -p -m 700 /home/$u
		cp -a ${sysdir}/home/$u/.[^.]* \
	      	/home/$u 2>/dev/null
		chown -Rf ${USER_D}:${GROUP_D} /home/$u
	fi
done

for f in $(ls -A ${sysdir}/etc/skel)
do
	cp -a ${sysdir}/etc/skel/$f /root/
done

echo "${BLUE}Done.${NORMAL}"


## === Create /etc, /var, and /usr Directories === ##
echo -n "${CRE}${BLUE}Creating ${YELLOW}/etc ${BLUE}, ${YELLOW}/var ${BLUE}and ${YELLOW}/usr ${BLUE}directories...${NORMAL}"

# Create WRITABLE dirs
mkdir -p /var/lib /var/lock /var/log /var/nis \
	/var/preserve /var/run /var/tmp /var/opt \
	/var/spool/cups/tmp \
	/mnt/floppy \
	/etc/sysconfig /etc/X11 /etc/cups /etc/alternatives \
	/selinux

# Create WRITABLE files
cp -a ${sysdir}/etc/cups/*.conf /etc/cups/ 2>/dev/null
cp -a ${sysdir}/etc/alternatives/* /etc/alternatives/ 2>/dev/null
cp -a ${sysdir}/etc/passwd ${sysdir}/etc/shadow ${sysdir}/etc/group ${sysdir}/etc/gshadow ${sysdir}/etc/asound.state ${sysdir}/etc/adjtime \
	${sysdir}/etc/ppp ${sysdir}/etc/ssh ${sysdir}/etc/exports ${sysdir}/etc/resolv.conf \
	${sysdir}/etc/sysconfig /etc/ 2>/dev/null
cp -a ${sysdir}/var/opt/atokx2 /var/opt/ 2>/dev/null
cp -a ${sysdir}/var/local ${sysdir}/var/spool ${sysdir}/var/webmin /var/ 2>/dev/null
cp -a ${sysdir}/var/lib/random-seed ${sysdir}/var/lib/xkb ${sysdir}/var/lib/pcmcia ${sysdir}/var/lib/dhcp* ${sysdir}/var/lib/nfs /var/lib/ 2>/dev/null
:> /var/run/utmp
:> /var/run/wtmp

# Create links from CDROM for UNWRITABLE (remaining) files
cp -aus ${sysdir}/var/* /var/ 2>/dev/null
cp -aus ${sysdir}/etc/* /etc/ 2>/dev/null

# Relink for making these files WRITABLE
rm -f /etc/grub.conf
rm -f /etc/sysconfig/network-scripts/ifup /etc/sysconfig/network-scripts/ifdown
ln -s ../../boot/grub/grub.conf /etc/grub.conf >/dev/null 2>&1
ln -s ../../../../sbin/ifup /etc/sysconfig/network-scripts/ifup >/dev/null 2>&1
ln -s ../../../../sbin/ifdown /etc/sysconfig/network-scripts/ifdown >/dev/null 2>&1
lnkdaemon netfs

# Remove Unnecessary Files
rm -rf /etc/passwd- /etc/shadow- /etc/group- /etc/gshadow-
rm -rf /etc/modprobe.conf
rm -rf /etc/X11/XF86Config*
rm -rf /var/log/*
rm -rf /etc/sysconfig/network-scripts/ifcfg-eth* /etc/sysconfig/network-scripts/ifcfg-tr*

# /usr
mkdir -p /ramdisk/usr/X11R6/lib/X11
cp -a ${sysdir}/usr/X11R6/lib/X11/xkb /ramdisk/usr/X11R6/lib/X11/ 2>/dev/null
mklnk ${sysdir}/usr/ /ramdisk/usr/
mklnk ${sysdir}/usr/X11R6/ /ramdisk/usr/X11R6/
mklnk ${sysdir}/usr/X11R6/lib/ /ramdisk/usr/X11R6/lib/
mklnk ${sysdir}/usr/X11R6/lib/X11/ /ramdisk/usr/X11R6/lib/X11/
ln -sf /ramdisk/usr / >/dev/null 2>&1

echo "${BLUE}Done.${NORMAL}"


## === Now tell kernel where the real modprobe lives === ##
echo "/sbin/modprobe" > /proc/sys/kernel/modprobe

## === Stop kudzu to use auto configuration tools === ##
chkconfig --level 0123456 kudzu off

## === change root device from /dev/fd0 to /dev/ram0 === ##
echo "0x100" > /proc/sys/kernel/real-root-dev
umount /proc

## === Give control to the init process === ##
echo "${CRE}${BLUE}Starting init process.${NORMAL}"
rm -f /linuxrc
#rm -rf ${moddir} /exec
exit 0

