#!/bin/bash
#========================================================#
# Make One Linux -- mkisofs-mol script
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#========================================================#
# This script makes iso9660 image for Make One Linux.
#

## === Environment Variable === ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## === Read molmakerc === ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## === Read options === ##
case "$*" in
	# Help
	*--help*)
	echo "Make One Linux -- mkisofs-mol script"
	echo " (C)2005 Make One Linux Project <dgel@users.sourceforge.jp>"
	echo
	echo "This script makes iso9660 image for Make One Linux."
	echo "Usage: mkisofs-mol [option]"
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	echo -n "${BLUE}Removing ${MAGENTA}iso9660 image and other setting${NORMAL}"
	if [ -d ${BUILD_ROOT}/mol-${MOLVERSION} ]
	then
		mv ${BUILD_ROOT}/mol-${MOLVERSION}/MOL/MOL ${BUILD_ROOT}/MOL >/dev/null 2>&1 && chkok
		rm -Rf ${BUILD_ROOT}/mol-${MOLVERSION} >/dev/null 2>&1 && chkok
	fi
	rm -f ${BUILD_ROOT}/isolinux.cfg >/dev/null 2>&1 && chkok
	rm -f ${ISODIR}/MOL-${MOLVERSION}-${DISTRIBUTION}.iso >/dev/null 2>&1 && chkok
	rm -f  ${BUILD_ROOT}/mkisofs-mol.flag && chkok
	echo "${GREEN}Done${NORMAL}"
	exit 0 ;;
esac

## === Check flag === ##
if [ ! -f "${BUILD_ROOT}/mksquashfs-mol.flag" ]
then
	echo "Error: First, please execute mksquashfs-mol script."
	exit 1
fi
if [ -f "${BUILD_ROOT}/mkisofs-mol.flag" ]
then
	echo "Warning: First, please execute this script with --clean option."
	exit 1
fi

## === Start === ##
echo "${MAGENTA}mkisofs-mol Starting${NORMAL}"

# Whether using squashfs or not
if [ "${ENABLE_SQUASHFS}" = "yes" ]
then
	# make build directories
	echo -n "${BLUE}Making build directories${NORMAL}"
	MOLROOT="${BUILD_ROOT}/mol-${MOLVERSION}"
	EXCLUDE_FROM_ISO=""
	mkdir -p ${MOLROOT}          && chkok || chkfail
	mkdir -p ${MOLROOT}/boot     && chkok || chkfail
	mkdir -p ${MOLROOT}/MOL      && chkok || chkfail
	touch ${MOLROOT}/MOL/MOLFLAG && chkok || chkfail
	mv -f ${BUILD_ROOT}/MOL ${MOLROOT}/MOL/MOL && chkok || chkfail
else
	# set exclusion list
	echo -n "${BLUE}Setting exclusion list${NORMAL}"
	EXCLUDE_LIST=$(mklist "$EX_FILE_LIST" 2>/dev/null ; mklist "$EX_PKG_LIST" 2>/dev/null) && chkok || chkfail
	EXCLUDE_LIST="/.autofsck /proc /sys /tmp /usr/tmp /var/tmp /var/log /dev /initrd /lost+found /mnt ${BUILD_ROOT} ${ISODIR} ${EXCLUDE_LIST}" && chkok || chkfail
	EXCLUDE_LIST="$(echo $EXCLUDE_LIST | sed -e 's/\\\ /@@SpAcE@@/g')"
	EXCLUDE_LIST="$(echo $EXCLUDE_LIST | sed -e 's/\ /\ -x\ /g')"
	EXCLUDE_LIST="$(echo $EXCLUDE_LIST | sed -e 's/@@SpAcE@@/\\\ /g')"
	[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_ISO="-x ${EXCLUDE_LIST}" && chkok || chkfail
	MOLROOT=""
fi
echo "${GREEN}Done${NORMAL}"


# Copying isolinux, kernel image, initrd.img
echo -n "${BLUE}Copying isolinux, kernel image, initrd.img${NORMAL}"
#chown -Rf root:root isolinux >/dev/null 2>&1 && chkok || chkfail
#cp -a ${SYSLINUXDIR}                  ${MOLROOT}/boot/isolinux            >/dev/null 2>&1 && chkok || chkfail
cp -a ${DATADIR}/mol/isolinux         ${MOLROOT}/boot/isolinux              >/dev/null 2>&1 && chkok || chkfail
cp -a ${ISOLINUXBIN}                  ${MOLROOT}/boot/isolinux/isolinux.bin >/dev/null 2>&1 && chkok || chkfail
cp -a /boot/vmlinuz-${KERNEL_RELEASE} ${MOLROOT}/boot/isolinux/vmlinuz      >/dev/null 2>&1 && chkok || chkfail
cp -a ${BUILD_ROOT}/initrd.img        ${MOLROOT}/boot/isolinux/initrd.img   >/dev/null 2>&1 && chkok || chkfail
rm -f ${MOLROOT}/boot/isolinux/isolinux.cfg.in >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Setting default boot options
echo -n "${BLUE}Setting default boot options${NORMAL}"
sed -e "s|@@BOOTOPTION@@|${BOOTOPTION}|g" ${DATADIR}/mol/isolinux/isolinux.cfg.in > ${MOLROOT}/boot/isolinux/isolinux.cfg && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

# Making iso9660 image
echo "${BLUE}Making iso9660 image${NORMAL}"
echo -n "${CYAN}This may take a while${NORMAL}"
mkisofs -l -r -J -R -V "MOL-${MOLVERSION}-${DISTRIBUTION}" -b boot/isolinux/isolinux.bin -c boot/isolinux/isolinux.cat -no-emul-boot -boot-load-size 4 -boot-info-table -hide-rr-moved -v ${EXCLUDE_FROM_ISO} -o ${ISODIR}/MOL-${MOLVERSION}-${DISTRIBUTION}.iso ${MOLROOT}/ >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"


## === fin. === ##
touch ${BUILD_ROOT}/mkisofs-mol.flag
echo "${MAGENTA}mkisofs-mol Finished${NORMAL}"
exit 0

