#!/bin/bash
#
# MKISOFS-MOL -- This program makes iso9660 image for Make One Linux
# Copyright (C) 2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

## === Setup Environment === ##
## Set path ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## Read molmakerc ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## Read options ##
case "$*" in
	# Help
	*--help*)
	echo "MKISOFS-MOL (Make One Linux) ${MOLVERSION}"
	echo " (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>"
	echo
	echo "This program makes iso9660 image for Make One Linux."
	echo "Usage: mkisofs-mol [option]"
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo "   --version       : Show version and notice"
	echo
	exit 0 ;;
	# Version
	*--version*)
	echo "MKISOFS-MOL (Make One Linux) ${MOLVERSION}"
	echo "Written by Keicho Kondo."
	echo
	echo "Copyright (C) 2005-2006 Keicho Kondo."
	echo "This is free software; see the source for copying conditions.  There is NO"
	echo "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	echo -n "${BLUE}Removing ${MAGENTA}iso9660 image and other setting${NORMAL}"
	if [ -d ${BUILD_ROOT}/mol-${MOLVERSION} ]
	then
		mv ${BUILD_ROOT}/mol-${MOLVERSION}/MOL/MOL ${BUILD_ROOT}/MOL >/dev/null 2>&1 && chkok
		rm -Rf ${BUILD_ROOT}/mol-${MOLVERSION} >/dev/null 2>&1 && chkok
	fi
	#rm -f ${BUILD_ROOT}/isolinux.cfg >/dev/null 2>&1 && chkok
	rm -f ${ISODIR}/MOL-${MOLVERSION}${ISO_SUFFIX}.iso >/dev/null 2>&1 && chkok
	rm -f  ${BUILD_ROOT}/mkisofs-mol.flag && chkok
	echo "${GREEN}Done${NORMAL}"
	exit 0 ;;
esac

## Check flag ##
if [ ! -f "${BUILD_ROOT}/mkinitrd-mol.flag" ]
then
	echo "Error: First, please execute mkinitrd-mol script."
	exit 1
elif [ ! -f "${BUILD_ROOT}/mkfs-mol.flag" ]
then
	echo "Error: First, please execute mkfs-mol script."
	exit 1
elif [ -f "${BUILD_ROOT}/mkisofs-mol.flag" ]
then
	echo "Warning: First, please execute this script with --clean option."
	exit 1
fi


## === Start === ##
echo "${MAGENTA}mkisofs-mol Starting${NORMAL}"

## Image system ##
if [ "${MAIN_FS}" = "squashfs" ] || [ "${MAIN_FS}" = "cloop" ] || [ "${MAIN_FS}" = "ext2" ] || [ "${MAIN_FS}" = "ext3" ] || [ "${MAIN_FS}" = "reiserfs" ]
then
	# make build directories
	echo -n "${BLUE}Making build directories${NORMAL}"
	MOLROOT="${BUILD_ROOT}/mol-${MOLVERSION}"
	EXCLUDE_FROM_ISO=""
	mkdir -p ${MOLROOT}          && chkok || chkfail
	mkdir -p ${MOLROOT}/boot     && chkok || chkfail
	mkdir -p ${MOLROOT}/MOL      && chkok || chkfail
	touch ${MOLROOT}/MOL/MOLFLAG && chkok || chkfail
	echo "MOLVERSION=${MOLVERSION}"         >> ${MOLROOT}/MOL/MOLFLAG && chkok || chkfail
	echo "KERNEL_RELEASE=${KERNEL_RELEASE}" >> ${MOLROOT}/MOL/MOLFLAG && chkok || chkfail
	mkdir -p ${MOLROOT}/etc/mol  && chkok || chkfail # 0.6.0
	echo "Image" > ${MOLROOT}/etc/mol/MOLTYPE && chkok || chkfail # 0.6.0
	mv -f ${BUILD_ROOT}/MOL ${MOLROOT}/MOL/MOL && chkok || chkfail
	echo "Image" > ${MOLROOT}/.BASETYPE # 0.6.0

## Raw system ##
else
	# set exclusion list
	echo -n "${BLUE}Setting exclusion list${NORMAL}"
	EXCLUDE_LIST=$(mklist "$EX_FILE_LIST" 2>/dev/null ; mklist "$EX_PKG_LIST" 2>/dev/null) && chkok || chkfail
	EXCLUDE_LIST="/.autofsck /proc /selinux /sys /tmp /usr/tmp /var/tmp /dev /initrd /lost+found ${BUILD_ROOT} ${ISODIR} ${EXCLUDE_LIST}" && chkok || chkfail
	EXCLUDE_LIST="$(echo $EXCLUDE_LIST | sed -e 's/\ /\ -x\ /g')"
	[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_ISO="-x ${EXCLUDE_LIST}" && chkok || chkfail
	MOLROOT=""
	echo "RAW" > ${MOLROOT}/.BASETYPE # 0.6.0
fi
echo "${GREEN}Done${NORMAL}"

## Copying mol installer ##
if [ "${INSTALL2WIN}" = "yes" ] || [ "${INSTALL2LIN}" = "yes" ]
then
	echo -n "${BLUE}Copying mol installer${NORMAL}"
	mkdir -p ${MOLROOT}/boot/grub
	if [ "${INSTALL2WIN}" = "yes" ]
	then
		install -m 644 ${DATADIR}/mol/installer/stage[12]       ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/flushdrv.exe    ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/msgbox.exe      ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/grubinstall.exe ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/setup.bat       ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/unsetup.bat     ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/mkmenu.bat      ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/install2win.bat ${MOLROOT}/           && chkok || chkfail
	fi
	if [ "${INSTALL2LIN}" = "yes" ]
	then
		install -m 755 ${DATADIR}/mol/installer/setup.sh        ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/unsetup.sh      ${MOLROOT}/boot/grub/ && chkok || chkfail
		install -m 755 ${DATADIR}/mol/installer/install2lin.sh  ${MOLROOT}/           && chkok || chkfail
	fi
	echo "${GREEN}Done${NORMAL}"
fi

## Copying isolinux, kernel image, initrd.img ##
echo -n "${BLUE}Copying isolinux, kernel image, initrd.img${NORMAL}"
cp -a ${DATADIR}/mol/isolinux         ${MOLROOT}/boot/isolinux              >/dev/null 2>&1 && chkok || chkfail
cp -a ${SYSCONFDIR}/mol/isolinux.cfg  ${MOLROOT}/boot/isolinux/isolinux.cfg >/dev/null 2>&1 && chkok || chkfail
cp -a ${ISOLINUXBIN}                  ${MOLROOT}/boot/isolinux/isolinux.bin >/dev/null 2>&1 && chkok || chkfail
cp -a /boot/vmlinuz-${KERNEL_RELEASE} ${MOLROOT}/boot/isolinux/vmlinuz      >/dev/null 2>&1 && chkok || chkfail
cp -a ${BUILD_ROOT}/initrd.img        ${MOLROOT}/boot/isolinux/initrd.img   >/dev/null 2>&1 && chkok || chkfail
#rm -f ${MOLROOT}/boot/isolinux/isolinux.cfg.in >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

## Setting default boot options ##
#echo -n "${BLUE}Setting default boot options${NORMAL}"
#sed -e "s|@@BOOTOPTION@@|${BOOTOPTION}|g" ${DATADIR}/mol/isolinux/isolinux.cfg.in > ${MOLROOT}/boot/isolinux/isolinux.cfg && chkok || chkfail
#echo "${GREEN}Done${NORMAL}"

## Making iso9660 image ##
echo "${BLUE}Making iso9660 image${NORMAL}"
echo -n "${CYAN}This may take a while${NORMAL}"
mkisofs -l -r -J -R -V "MOL-${MOLVERSION}${ISO_SUFFIX}" -b boot/isolinux/isolinux.bin -c boot/isolinux/isolinux.cat -no-emul-boot -boot-load-size 4 -boot-info-table -hide-rr-moved -v ${EXCLUDE_FROM_ISO} -o ${ISODIR}/MOL-${MOLVERSION}${ISO_SUFFIX}.iso ${MOLROOT}/ >/dev/null 2>&1 && chkok || chkfail
echo "${GREEN}Done${NORMAL}"


## === fin. === ##
touch ${BUILD_ROOT}/mkisofs-mol.flag
echo "${MAGENTA}mkisofs-mol Finished${NORMAL}"
exit 0

