#!/bin/bash
#
# MKFS-MOL -- This program makes main system for Make One Linux
# Copyright (C) 2006 Keicho Kondo <dgel@users.sourceforge.jp>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

## === Setup Environment === ##
## Set path ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## Read molmakerc ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## Read options ##
case "$*" in
	# Help
	*--help*)
	echo "MKFS-MOL (Make One Linux) ${MOLVERSION}"
	echo " (C)2006 Keicho Kondo <dgel@users.sourceforge.jp>"
	echo
	echo "This program makes main system for Make One Linux."
	echo "Usage: mkfs-mol [option]"
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo "   --version       : Show version and notice"
	echo
	exit 0 ;;
	# Version
	*--version*)
	echo "MKFS-MOL (Make One Linux) ${MOLVERSION}"
	echo "Written by Keicho Kondo."
	echo
	echo "Copyright (C) 2006 Keicho Kondo."
	echo "This is free software; see the source for copying conditions.  There is NO"
	echo "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	echo -n "${BLUE}Removing ${MAGENTA}main filesystem image${NORMAL}"
	rm -f ${BUILD_ROOT}/MOL >/dev/null 2>&1 && chkok
	rm -f ${BUILD_ROOT}/mkfs-mol.flag && chkok
	echo "${GREEN}Done${NORMAL}"
	exit 0 ;;
esac

#image_size()
#{
#	while [ 0 ]; do
#		[ -e ${BUILD_ROOT}/MOL ] && echo -n "${CRE}${BLUE}Image size is : ${MAGENTA}$(du -h ${BUILD_ROOT}/MOL | awk '{print $1}')${NORMAL}"
#		sleep 2
#	done
#}

## Check flag ##
if [ -f "${BUILD_ROOT}/mkfs-mol.flag" ]
then
	echo "Warning: First, please execute this script with --clean option."
	exit 1
fi


## === Start === ##
echo "${MAGENTA}mkfs-mol Starting${NORMAL}"

## Set exclusion list ##
echo -n "${BLUE}Setting exclusion list${NORMAL}"
EXCLUDE_LIST=$(mklist "$EX_FILE_LIST" 2>/dev/null ; mklist "$EX_PKG_LIST" 2>/dev/null) && chkok || chkfail
EXCLUDE_LIST="/.autofsck /proc /selinux /sys /tmp /usr/tmp /var/tmp /dev /initrd /lost+found ${BUILD_ROOT} ${ISODIR} ${EXCLUDE_LIST}" && chkok || chkfail
echo "${GREEN}Done${NORMAL}"

## Making MOL System ##
mkdir -p ${BUILD_ROOT}
# for SQUASHFS Image #
if [ "${MAIN_FS}" = "squashfs" ]
then
	echo "${BLUE}Making squashfs image${NORMAL}"
	echo -n "${CYAN}This may take a while${NORMAL}"
	# exclusion list
	[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_SQUASHFS="-e ${EXCLUDE_LIST}" && chkok || chkfail
	# start making
	#image_size &
	#${MKSQUASHFS} / ${BUILD_ROOT}/MOL ${EXCLUDE_FROM_SQUASHFS} >/dev/null 2>&1 && chkok || { kill $! >/dev/null 2>&1; chkfail; }
	#kill $! >/dev/null 2>&1
	${MKSQUASHFS} / ${BUILD_ROOT}/MOL ${EXCLUDE_FROM_SQUASHFS} >/dev/null 2>&1 && chkok || chkfail
	echo "${GREEN}Done${NORMAL}"

# for CLOOP Image #
#elif [ "${MAIN_FS}" = "cloop" ]
#then
#	echo "${BLUE}Making cloop image${NORMAL}"
#	echo -n "${CYAN}This may take a while${NORMAL}"
#	# exclusion list
#	EXCLUDE_FROM_CLOOP="$(echo $EXCLUDE_LIST | sed -e 's/\ /\ -x\ /g')"
#	[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_CLOOP="-x ${EXCLUDE_FROM_CLOOP}" && chkok || chkfail
#	# start making
#	echo -n "${CYAN}This may take a while${NORMAL}"
#	mkisofs -R -l -V "MOL Main System" -hide-rr-moved -v ${EXCLUDE_FROM_CLOOP} / 2>/dev/null | create_compressed_fs - 65536 >${BUILD_ROOT}/MOL 2>/dev/null && chkok || chkfail
#	echo "${GREEN}Done${NORMAL}"

# for EXT2/3 or REISERFS Image #
elif [ "${MAIN_FS}" = "ext2" ] || [ "${MAIN_FS}" = "ext3" ] || [ "${MAIN_FS}" = "reiserfs" ]
then
	echo "${BLUE}Making ${MAIN_FS} image${NORMAL}"
	echo -n "${CYAN}This may take a while${NORMAL}"
	# create ext2/3 or resierfs to ram
	dd if=/dev/zero of=${BUILD_ROOT}/MOL bs=${MAINFS_BS} count=${MAINFS_COUNT} >/dev/null 2>&1 && chkok || chkfail
	losetup /dev/loop2 ${BUILD_ROOT}/MOL >/dev/null 2>&1 && chkok || chkfail
	mkfs -t "${MAIN_FS}" /dev/loop2 ${MAINFS_COUNT} >/dev/null 2>&1 && chkok || chkfail
	# exclusion list
	EXCLUDE_FROM_IMAGE="$(echo $EXCLUDE_LIST | sed -e "s@\ @\ ${BUILD_ROOT}/loop@g")"
	[ -n "${EXCLUDE_LIST}" ] && EXCLUDE_FROM_IMAGE="${BUILD_ROOT}/loop${EXCLUDE_FROM_IMAGE}" && chkok || chkfail
	# copy contents of main filesystem to ram
	[ -d ${BUILD_ROOT}/loop ] || mkdir -p ${BUILD_ROOT}/loop >/dev/null 2>&1 && chkok || chkfail
	mount -t "${MAIN_FS}" -o loop /dev/loop2 ${BUILD_ROOT}/loop >/dev/null 2>&1 && chkok || chkfail
	[ -n "${EXCLUDE_LIST}" ] && mkdir -p ${EXCLUDE_FROM_IMAGE} >/dev/null 2>&1 && chkok
	[ -n "${EXCLUDE_LIST}" ] && rm -rf   ${EXCLUDE_FROM_IMAGE} >/dev/null 2>&1 && chkok
	[ -n "${EXCLUDE_LIST}" ] && touch    ${EXCLUDE_FROM_IMAGE} >/dev/null 2>&1 && chkok
	cp -au /[^.]*  ${BUILD_ROOT}/loop/ >/dev/null 2>&1 && chkok
	cp -au /.[^.]* ${BUILD_ROOT}/loop/ >/dev/null 2>&1 && chkok
	[ -n "${EXCLUDE_LIST}" ] && rm -f ${EXCLUDE_FROM_IMAGE} >/dev/null 2>&1 && chkok
	# finish
	umount /dev/loop2 >/dev/null 2>&1 && chkok || chkfail
	losetup -d /dev/loop2 >/dev/null 2>&1 && chkok || chkfail
	rmdir ${BUILD_ROOT}/loop >/dev/null 2>&1 && chkok || chkfail
	echo "${GREEN}Done${NORMAL}"

# for RAW #
else
	echo "${CYAN}Select Raw Filesystem${NORMAL}"
fi


## === fin. === ##
touch ${BUILD_ROOT}/mkfs-mol.flag
echo "${MAGENTA}mkfs-mol Finished${NORMAL}"
exit 0

