#!/bin/bash
#
# MOLMAKE -- This program starts up Make One Linux setup
# Copyright (C) 2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

## === Setup Environment === ##
## Set path ##
PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"

## Read molmakerc ##
RCFILE="@@SYSCONFDIR@@/mol/molmakerc"
if [ -f "${RCFILE}" ]
then
	. "${RCFILE}"
else
	echo "Cannot find molmakerc file!"
	exit 1
fi

## Read options ##
case "$*" in
	# Help
	*--help*)
	echo "MOLMAKE (Make One Linux) ${MOLVERSION}"
	echo " (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp>"
	echo
	echo "This program starts up Make One Linux setup."
	echo "Usage: molmake <option>"
	echo
	echo "   --clean         : Clean up files made by this script"
	echo "   --help          : Show this help"
	echo "   --version       : Show version and notice"
	echo
	exit 0 ;;
	# Version
	*--version*)
	echo "MOLMAKE (Make One Linux) ${MOLVERSION}"
	echo "Written by Keicho Kondo."
	echo
	echo "Copyright (C) 2005-2006 Keicho Kondo."
	echo "This is free software; see the source for copying conditions.  There is NO"
	echo "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
	echo
	exit 0 ;;
	# Clean up prepared files
	*--clean*)
	${SBINDIR}/mkisofs-mol --clean
	${SBINDIR}/mkfs-mol --clean
	${SBINDIR}/mkinitrd-mol --clean
	exit 0 ;;
esac


## === Start === ##
echo "${MAGENTA}<-- ${RED}Make ${CYAN}One ${GREEN}Linux ${BLUE}Setup Starting ${MAGENTA}-->${NORMAL}"
echo ""
echo ""

## Execute script files ##
echo "${MAGENTA}<- ${BLUE}Stage 1 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mkinitrd-mol
echo ""
echo "${MAGENTA}<- ${BLUE}Stage 2 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mkfs-mol
echo ""
echo "${MAGENTA}<- ${BLUE}Stage 3 ${MAGENTA}->${NORMAL}"
${SBINDIR}/mkisofs-mol
echo ""
echo ""


## === fin. === ##
echo "${MAGENTA}<-- ${RED}Make ${CYAN}One ${GREEN}Linux ${BLUE}Setup Finished ${MAGENTA}-->${NORMAL}"
exit 0

