#!/bin/sh

## stop kudzu to use auto configuration tools ##
chkconfig --level 0123456 kudzu off

## xfs is necessary for xorg.conf ##
[ -f /etc/rc.d/init.d/xfs ] && chkconfig --level 5 xfs on

## setup network configuration
for f in $(echo /etc/sysconfig/mol/ifcfg-*); do
	NIC="${f##*-}"
	. $f
	if [ "$BOOTPROTO" == "static" ]; then
		if [ -f /etc/sysconfig/network-scripts/ifcfg-${NIC} ]; then
			rm -f /etc/sysconfig/network-scripts/ifcfg-${NIC}
#-----------------------------------------------------------------
cat >/etc/sysconfig/network-scripts/ifcfg-${NIC} <<EOF
DEVICE=$NIC
ONBOOT=yes
BOOTPROTO=static
IPADDR=$IPADDR
NETMASK=$NETMASK
EOF
#-----------------------------------------------------------------
		fi
		if [ -f /etc/sysconfig/network ]; then
			mv /etc/sysconfig/network /etc/sysconfig/network.tmp
			sed -e 's/^GATEWAY/#GATEWAY/' </etc/sysconfig/network.tmp >/etc/sysconfig/network
			echo "GATEWAY=$GATEWAY" >>/etc/sysconfig/network
			rm -f /etc/sysconfig/network.tmp
		fi
	elif [ "$BOOTPROTO" == "dhcp" ]; then
		if [ -f /etc/sysconfig/network-scripts/ifcfg-${NIC} ]; then
			rm -f /etc/sysconfig/network-scripts/ifcfg-${NIC}
#---------------------------------------------------------------
cat >/etc/sysconfig/network-scripts/ifcfg-${NIC} <<EOF
DEVICE=$NIC
ONBOOT=yes
BOOTPROTO=dhcp
EOF
#---------------------------------------------------------------
		fi
	fi
done

