/*
 * GetNichData.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.nich;

import org.monache.nagesen.NagesenException;

/**
 * 
 * 
 * @author monache.org
 * @since 
 */
public interface GetNichData {

	public static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
	public static final String HEADER_RANGE = "Range";
	public static final String HEADER_LAST_MODIFIED = "Last-Modified";
	
	public static final String CHARSET = "Shift-JIS"; // TODO MS932?
	
	public static final String DELIMITER = "<>";
	
	public static final int STATUS_FOUND = 200;
	public static final int STATUS_MODIFIED = 206;
	public static final int STATUS_NOT_MODIFIED = 304;
	public static final int STATUS_NOT_FOUND = 416;

	public GetNichDataResult get(String url, String modifiedSince, long range) throws NagesenException;
}
