/*
 * AddressValidatorFactory.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.validator.address;

import org.monache.nagesen.Constant;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class AddressValidatorFactory {

	/**
	 * 
	 * @since 1.0
	 */
	private AddressValidatorFactory() {
		// TODO 自動生成されたコンストラクター・スタブ
	}

	public static AbstractAddressValidator newValidator(String coin) {
		
		if (Constant.MONACOIN.equals(coin)) {
			return new MonacoinValidator();
		} else if (Constant.KUMACOIN.equals(coin)) {
			return new KumacoinValidator();
		}
		// TODO error
		return null;
	}
	
}
