/*
 * IncludeMessageValidator.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.validator.message;

import org.apache.commons.lang.StringUtils;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class IncludeMessageValidator extends AbstractMessageValidator {

	private String[] checkString = null;
	
	/**
	 * @return checkString
	 * @since 1.0
	 */
	public String[] getCheckString() {
		return checkString;
	}

	/**
	 * @param checkString セットする checkString
	 * @since 1.0
	 */
	public void setCheckString(String[] checkString) {
		this.checkString = checkString;
	}

	/**
	 * 
	 * @since 1.0
	 */
	public IncludeMessageValidator() {
	}

	/* (非 Javadoc)
	 * @see org.monache.nagesen.validator.message.MessageValidator#validate(org.monache.nagesen.AddressData)
	 * @since 1.0
	 */
	public boolean validate(String message) {
		
		if (getCheckString() == null || getCheckString().length == 0) {
			return true;
		}
		if (StringUtils.isEmpty(message)) {
			return false;
		}
		for (String str : getCheckString()) {
			if (message.indexOf(str) != -1) {
				return true;
			}
		}
		
		return false;
	}

}
