/*
 * FixedAmount.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.amount;

import java.math.BigDecimal;

import org.monache.nagesen.AddressData;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class FixedAmount implements Amount {

	private BigDecimal amount = null;
	

	/**
	 * 
	 * @since 1.0
	 */
	public FixedAmount() {
	}

	/* (非 Javadoc)
	 * @see org.monache.nagesen.amount.AmountLogic#calc(org.monache.nagesen.AddressData)
	 * @since 1.0
	 */
	public BigDecimal calc(AddressData data) {
		return getAmount();
	}
	
	/**
	 * @return amount
	 * @since 1.0
	 */
	public BigDecimal getAmount() {
		return amount;
	}

	/**
	 * @param fixedAmount セットする fixedAmount
	 * @since 1.0
	 */
	public void amount(BigDecimal amount) {
		this.amount = amount;
	}


}
