/*
 * Decompiled with CFR 0.152.
 */
package monalipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import monalipse.bookmark.BookmarkManager;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IThreadContentProvider;
import monalipse.views.IBBSReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MonalipsePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "monalipse";
    public static final String NATURE_ID = "monalipse.monalipsenature";
    public static final String IMG_OBJ_BOARD;
    public static final String IMG_OBJ_THREAD;
    public static final String IMG_OBJ_FOLDER;
    public static final String IMG_OVR_BOOKMARK;
    public static final String IMG_OVR_SUCCESS;
    private static MonalipsePlugin plugin;
    private static final Logger logger;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMG_OBJ_BOARD = String.valueOf(clazz2.getName()) + ".obj.board";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMG_OBJ_THREAD = String.valueOf(clazz3.getName()) + ".obj.thread";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMG_OBJ_FOLDER = String.valueOf(clazz4.getName()) + ".obj.folder";
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMG_OVR_BOOKMARK = String.valueOf(clazz5.getName()) + ".ovr.bookmark";
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMG_OVR_SUCCESS = String.valueOf(clazz6.getName()) + ".ovr.success";
        try {
            FileInputStream inputStream = new FileInputStream(new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "logging.properties"));
            LogManager.getLogManager().readConfiguration(inputStream);
            inputStream.close();
            System.err.println("logging.properties read");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.MonalipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = MonalipsePlugin.getLogger(clazz);
    }

    public MonalipsePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("monalipse.MonalipsePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)PLUGIN_ID).getDescriptor().getInstallURL();
        try {
            reg.put(IMG_OBJ_BOARD, ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "category_obj.gif")));
            reg.put(IMG_OBJ_THREAD, ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "file_obj.gif")));
            reg.put(IMG_OBJ_FOLDER, ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "fldr_obj.gif")));
            reg.put(IMG_OVR_BOOKMARK, ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "bkmrk_ovr.gif")));
            reg.put(IMG_OVR_SUCCESS, ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "success_ovr.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public Image getOverlayImage(String base, boolean bookmarked, boolean updated) {
        String key;
        ImageRegistry reg = this.getImageRegistry();
        Image image = reg.get(key = String.valueOf(base) + bookmarked + updated);
        if (image == null) {
            OverlayImageDescriptor ovr = new OverlayImageDescriptor(reg.get(base).getImageData());
            if (bookmarked) {
                ovr.setTopRightImage(reg.get(IMG_OVR_BOOKMARK).getImageData());
            }
            if (updated) {
                ovr.setBottomLeftImage(reg.get(IMG_OVR_SUCCESS).getImageData());
            }
            reg.put(key, (ImageDescriptor)ovr);
            image = reg.get(key);
        }
        return image;
    }

    public Image getLabelImageOf(IBBSReference element) {
        boolean bookmarked = false;
        if (element instanceof IBBSReference) {
            bookmarked = BookmarkManager.getBookmarks().findItem(element.getURL()) != null;
        }
        boolean updated = false;
        IThreadContentProvider thread = null;
        if (element instanceof IThreadContentProvider) {
            thread = (IThreadContentProvider)element;
        } else if (!(element instanceof IBBSBoard)) {
            thread = BBSServerManager.getThreadContentProviderOf(element.getURL());
        }
        if (thread != null) {
            updated = thread.hasNewResponses();
        }
        if (thread == null) {
            return MonalipsePlugin.getDefault().getOverlayImage(IMG_OBJ_BOARD, bookmarked, updated);
        }
        return MonalipsePlugin.getDefault().getOverlayImage(IMG_OBJ_THREAD, bookmarked, updated);
    }

    public static MonalipsePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MonalipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String formatResourceString(String key, Object[] args) {
        return MessageFormat.format(MonalipsePlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static InputStream getUTFInputStream(String str) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(str);
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static void ensureSynchronized(IFile file) throws CoreException {
        logger.finest(file.toString());
        if (!file.isSynchronized(0)) {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);

            public String format(LogRecord record) {
                StringBuffer buf = new StringBuffer();
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(record.getMillis());
                buf.append(this.dateFormat.format(cal.getTime()));
                buf.append(' ');
                String clazz = record.getSourceClassName();
                buf.append(clazz.substring(clazz.lastIndexOf(46) + 1, clazz.length()));
                buf.append("#");
                buf.append(record.getSourceMethodName());
                int sp = Math.max(50 - buf.length(), 1);
                int i = 0;
                while (i < sp) {
                    buf.append(' ');
                    ++i;
                }
                buf.append(record.getMessage());
                buf.append('\n');
                return buf.toString();
            }

            private void append2DigitsNum(StringBuffer buf, int n) {
                if (n < 10) {
                    buf.append('0');
                }
                buf.append(n);
            }
        });
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        return logger;
    }

    public static IProject getProject() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IProject[] proj = root.getProjects();
        int i = 0;
        while (i < proj.length) {
            try {
                if (proj[i].getNature(NATURE_ID) != null) {
                    return proj[i];
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    public static boolean projectModified(IResourceDelta delta) {
        IProject project = MonalipsePlugin.getProject();
        return MonalipsePlugin.resourceModified(3, delta, (IResource)project);
    }

    public static boolean resourceModified(int type, IResourceDelta delta, IResource target) {
        boolean res = false;
        if (delta != null) {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren(type);
            int i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getResource().equals((Object)target)) {
                    return true;
                }
                res |= MonalipsePlugin.resourceModified(type, affectedChildren[i], target);
                ++i;
            }
        }
        return res;
    }

    public static void asyncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (!workbenchWindow.getShell().isDisposed()) {
                        workbenchWindow.run(false, false, run);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void syncExec(final IWorkbenchWindow workbenchWindow, final IRunnableWithProgress run) {
        workbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    if (!workbenchWindow.getShell().isDisposed()) {
                        workbenchWindow.run(false, false, run);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public class OverlayImageDescriptor
    extends CompositeImageDescriptor {
        private ImageData baseImage;
        private ImageData topLeftImage;
        private ImageData bottomLeftImage;
        private ImageData bottomRightImage;
        private ImageData topRightImage;

        public OverlayImageDescriptor(ImageData baseImage) {
            this.baseImage = baseImage;
        }

        protected Point getSize() {
            return new Point(this.baseImage.width, this.baseImage.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImage, 0, 0);
            if (this.topLeftImage != null) {
                this.drawImage(this.topLeftImage, 0, 0);
            }
            if (this.bottomLeftImage != null) {
                this.drawImage(this.bottomLeftImage, 0, height - this.bottomLeftImage.height);
            }
            if (this.bottomRightImage != null) {
                this.drawImage(this.bottomRightImage, width - this.bottomRightImage.width, height - this.bottomRightImage.height);
            }
            if (this.topRightImage != null) {
                this.drawImage(this.topRightImage, width - this.topRightImage.width, 0);
            }
        }

        public void setTopLeftImage(ImageData topLeftImage) {
            this.topLeftImage = topLeftImage;
        }

        public void setBottomLeftImage(ImageData bottomLeftImage) {
            this.bottomLeftImage = bottomLeftImage;
        }

        public void setBottomRightImage(ImageData bottomRightImage) {
            this.bottomRightImage = bottomRightImage;
        }

        public void setTopRightImage(ImageData topRightImage) {
            this.topRightImage = topRightImage;
        }
    }
}

