/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractTreeView
extends ViewPart
implements IResourceChangeListener {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_LABEL = "label";
    private static final String TAG_SCROLL = "scroll";
    private static final String TAG_VERTICAL_POSITION = "verticalPosition";
    private static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_FILTER = "filter";
    private IMemento memento;

    protected abstract Logger getLogger();

    protected abstract TreeViewer getViewer();

    protected abstract ITreeContentProvider getContentProvider();

    protected abstract ILabelProvider getLabelProvider();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected void partCreated() {
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
    }

    public void saveState(IMemento memento) {
        this.getLogger().finest("begin");
        if (this.getViewer() == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
        } else {
            this.saveExpansionState(memento);
            this.saveSelectionState(memento);
        }
        this.getLogger().finest("done");
    }

    private void saveScrollState(IMemento memento) {
        IMemento scrollMem = memento.createChild(TAG_SCROLL);
        scrollMem.putString(TAG_VERTICAL_POSITION, String.valueOf(this.getViewer().getTree().getVerticalBar().getSelection()));
        scrollMem.putString(TAG_HORIZONTAL_POSITION, String.valueOf(this.getViewer().getTree().getHorizontalBar().getSelection()));
    }

    private void saveSelectionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_SELECTION), ((IStructuredSelection)this.getViewer().getSelection()).toArray());
    }

    private void saveExpansionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_EXPANDED), this.getViewer().getVisibleExpandedElements());
    }

    private void setElements(IMemento memento, Object[] elements) {
        if (elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                while (this.getContentProvider().getParent(o) != null) {
                    IMemento labelMem = elementMem.createChild(TAG_LABEL);
                    labelMem.putString(TAG_LABEL, this.getLabelProvider().getText(o));
                    o = this.getContentProvider().getParent(o);
                }
                ++i;
            }
        }
    }

    protected void restoreState(IMemento memento) {
        this.getLogger().finest("begin");
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
        this.getLogger().finest("done");
    }

    private void restoreScrollState(IMemento memento) {
        IMemento scrollMem = memento.getChild(TAG_SCROLL);
        try {
            this.getViewer().getTree().getVerticalBar().setSelection(Integer.parseInt(scrollMem.getString(TAG_VERTICAL_POSITION)));
            this.getViewer().getTree().getHorizontalBar().setSelection(Integer.parseInt(scrollMem.getString(TAG_HORIZONTAL_POSITION)));
        }
        catch (RuntimeException runtimeException) {}
    }

    private void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(this.getElements(childMem)));
        }
    }

    private void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            this.getViewer().setExpandedElements(this.getElements(childMem).toArray());
        }
    }

    private List getElements(IMemento memento) {
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < elementMem.length) {
            IMemento[] labelMem = elementMem[i].getChildren(TAG_LABEL);
            Object[] children = this.getContentProvider().getElements(this.getViewer().getInput());
            Object e = null;
            int j = labelMem.length - 1;
            while (j >= 0) {
                e = this.findElement(children, labelMem[j].getString(TAG_LABEL));
                if (e == null) break;
                children = this.getContentProvider().getChildren(e);
                --j;
            }
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private Object findElement(Object[] list, String label) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (this.getLabelProvider().getText(list[i]).equals(label)) {
                return list[i];
            }
            ++i;
        }
        return null;
    }
}

