/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import monalipse.MonalipsePlugin;
import monalipse.actions.BookmarkAction;
import monalipse.bookmark.BookmarkManager;
import monalipse.editors.ThreadEditorInput;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.IThreadContentProvider;
import monalipse.utils.CancelableRunner;
import monalipse.views.IBBSReference;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public class ThreadListView
extends ViewPart
implements ISelectionListener,
IResourceChangeListener,
SelectionListener {
    public static final String ID_THREAD_LIST;
    private static final Logger logger;
    private static final String TAG_INPUT = "input";
    private static final String TAG_URL = "url";
    private static final String TAG_COLUMNWIDTH = "columnWidth";
    private static final String TAG_COLUMN = "column";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_LABEL = "label";
    private static final String TAG_TITLE = "title";
    private TableTreeViewer viewer;
    private ThreadListContentProvider provider;
    private CancelableRunner cancelable;
    private IAction reloadAction;
    private IAction abortAction;
    private IAction doubleClickAction;
    private BookmarkAction bookmarkAction;
    private IMemento memento;
    private Combo searchCombo;
    private String constraint;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_THREAD_LIST = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = MonalipsePlugin.getLogger(clazz2);
    }

    public ThreadListView() {
        logger.finest("<init>");
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        logger.finest("begin");
        this.viewer = new TableTreeViewer(parent, 66308);
        this.provider = new ThreadListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.makeColumns();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewer.getTableTree().addSelectionListener((SelectionListener)this);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.hookDragAndDrop();
        logger.finest("done");
        this.viewer.getTableTree().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    ThreadListView.this.reloadAction.run();
                }
            }
        });
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer.getInput() instanceof IBBSBoard) {
            Object[] changed;
            logger.finest("begin");
            IBBSBoard board = (IBBSBoard)this.viewer.getInput();
            if (board.threadListChanged(event)) {
                logger.finest("threadListChanged");
                this.refreshList();
                if (this.viewer.getVisibleExpandedElements().length == 0) {
                    this.expandFirstFragment();
                }
            }
            if ((changed = board.getChangedItems(event)) != null) {
                logger.finest("update");
                this.viewer.update(changed, null);
            }
            if (BookmarkManager.bookmarkChanged(event)) {
                this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf((IBBSBoard)this.viewer.getInput()));
                this.viewer.refresh(true);
            }
            logger.finest("done");
        }
    }

    private void refreshList() {
        if (this.provider != null) {
            logger.finest("begin");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)clazz.getName());
            this.saveState((IMemento)memento);
            logger.finest("reset input");
            this.viewer.setInput(this.viewer.getInput());
            this.restoreState((IMemento)memento);
            logger.finest("done");
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IBBSBoard board;
        Object first;
        if (!this.viewer.getTableTree().isDisposed() && selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IBBSReference && (board = BBSServerManager.getBoardOf(((IBBSReference)first).getURL())) != null) {
            this.selectionChanged(board);
        }
    }

    private void selectionChanged(IBBSBoard board) {
        logger.finest("begin");
        this.setTitle(board.getName());
        this.setTitleImage(MonalipsePlugin.getDefault().getLabelImageOf(board));
        if (this.viewer.getInput() == null || !this.viewer.getInput().equals(board)) {
            logger.finest("folder changed");
            if (this.viewer.getInput() instanceof IBBSBoard) {
                this.saveSearchWord((IResource)((IBBSBoard)this.viewer.getInput()).getLogFolder());
            }
            this.constraint = "";
            this.viewer.setInput((Object)board);
            this.restoreSearchWord((IResource)board.getLogFolder());
            if (this.provider.getElements(this.viewer.getInput()).length == 0) {
                logger.finest("empty thread list");
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ThreadListView.this.reloadAction.run();
                    }
                });
            } else {
                this.expandFirstFragment();
            }
        }
        logger.finest("done");
    }

    private void expandFirstFragment() {
        if (this.provider.hasChildren(this.viewer.getInput())) {
            logger.finest("begin");
            Object[] fragments = this.provider.getElements(this.viewer.getInput());
            if (fragments.length > 0 && this.provider.hasChildren(fragments[0])) {
                logger.finest("set expansion");
                this.viewer.setExpandedElements(new Object[]{fragments[0]});
            }
            logger.finest("done");
        }
    }

    public void widgetSelected(SelectionEvent e) {
        logger.finest("begin");
        IBBSReference ref = this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
        if (ref instanceof IThreadContentProvider) {
            ThreadViewerEditor.activateEditor(this.getSite(), (IThreadContentProvider)ref);
        }
        logger.finest("done");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void saveSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                logger.finest("begin");
                StringBuffer buf = new StringBuffer();
                String[] keys = this.searchCombo.getItems();
                int i = 0;
                while (i < keys.length && i < 10) {
                    buf.append(URLEncoder.encode(keys[i], "UTF-8")).append(" ");
                    ++i;
                }
                logger.finest("save search word: " + buf.toString());
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"), buf.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void restoreSearchWord(IResource res) {
        if (this.searchCombo != null && !this.searchCombo.isDisposed()) {
            try {
                this.searchCombo.removeAll();
                this.searchCombo.add("");
                String keys = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "search"));
                if (keys != null) {
                    logger.finest("restore search word: " + keys);
                    StringTokenizer tk = new StringTokenizer(keys);
                    while (tk.hasMoreTokens()) {
                        this.searchCombo.add(URLDecoder.decode(tk.nextToken(), "UTF-8"));
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public void saveState(IMemento memento) {
        logger.finest("begin");
        if (this.viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
        } else {
            this.saveColumnState(memento);
            this.saveInputState(memento);
            this.saveExpansionState(memento);
            this.saveSelectionState(memento);
        }
        logger.finest("done");
    }

    private void saveColumnState(IMemento memento) {
        IMemento widthMem = memento.createChild(TAG_COLUMNWIDTH);
        int i = 0;
        while (i < this.viewer.getTableTree().getTable().getColumnCount()) {
            IMemento columnMem = widthMem.createChild(TAG_COLUMN);
            columnMem.putInteger(TAG_WIDTH, this.viewer.getTableTree().getTable().getColumn(i).getWidth());
            ++i;
        }
    }

    private void saveInputState(IMemento memento) {
        IMemento elementMem = memento.createChild(TAG_INPUT);
        if (this.viewer.getInput() instanceof IBBSBoard) {
            elementMem.putString(TAG_URL, ((IBBSBoard)this.viewer.getInput()).getURL().toExternalForm());
        }
        elementMem.putString(TAG_TITLE, this.getTitle());
        if (this.viewer.getInput() instanceof IBBSBoard) {
            this.saveSearchWord((IResource)((IBBSBoard)this.viewer.getInput()).getLogFolder());
        }
    }

    private void saveSelectionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_SELECTION), ((IStructuredSelection)this.viewer.getSelection()).toArray());
    }

    private void saveExpansionState(IMemento memento) {
        this.setElements(memento.createChild(TAG_EXPANDED), this.viewer.getVisibleExpandedElements());
    }

    private void setElements(IMemento memento, Object[] elements) {
        if (this.provider == null) {
            return;
        }
        if (elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                Object o = elements[i];
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                while (this.provider.getParent(o) != null) {
                    IMemento labelMem = elementMem.createChild(TAG_LABEL);
                    labelMem.putString(TAG_LABEL, this.provider.getColumnText(o, 0));
                    o = this.provider.getParent(o);
                }
                ++i;
            }
        }
    }

    private void restoreState(IMemento memento) {
        logger.finest("begin");
        this.restoreColumnState(memento);
        this.restoreInputState(memento);
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
        logger.finest("done");
    }

    private void restoreColumnState(IMemento memento) {
        IMemento[] columnMem;
        IMemento widthMem = memento.getChild(TAG_COLUMNWIDTH);
        if (widthMem != null && (columnMem = widthMem.getChildren(TAG_COLUMN)) != null) {
            int i = 0;
            while (i < this.viewer.getTableTree().getTable().getColumnCount() && i < columnMem.length) {
                this.viewer.getTableTree().getTable().getColumn(i).setWidth(columnMem[i].getInteger(TAG_WIDTH).intValue());
                ++i;
            }
        }
    }

    private void restoreInputState(IMemento memento) {
        IMemento elementMem = memento.getChild(TAG_INPUT);
        if (elementMem != null) {
            String title;
            String url = elementMem.getString(TAG_URL);
            logger.finest(url);
            if (url != null) {
                try {
                    IBBSBoard board = BBSServerManager.getBoardOf(new URL(url));
                    if (board != null) {
                        this.viewer.setInput((Object)board);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if ((title = elementMem.getString(TAG_TITLE)) != null) {
                this.setTitle(title);
            }
        }
    }

    private void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(this.getElements(childMem)));
        }
    }

    private void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            this.viewer.setExpandedElements(this.getElements(childMem).toArray());
        }
    }

    private List getElements(IMemento memento) {
        ArrayList<Object> list = new ArrayList<Object>();
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < elementMem.length) {
            IMemento[] labelMem = elementMem[i].getChildren(TAG_LABEL);
            Object[] children = this.provider.getElements(this.viewer.getInput());
            Object e = null;
            int j = labelMem.length - 1;
            while (j >= 0) {
                e = this.findElement(children, labelMem[j].getString(TAG_LABEL));
                if (e == null) break;
                children = this.provider.getChildren(e);
                --j;
            }
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    private Object findElement(Object[] list, String label) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.length) {
            if (this.provider.getColumnText(list[i], 0).equals(label)) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ThreadListView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatuBar(bars.getStatusLineManager());
    }

    private void fillLocalStatuBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.reloadAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.abortAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.bookmarkAction.updateState(this.getSite().getWorkbenchWindow(), this.viewer.getSelection());
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.bookmarkAction);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ThreadListView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.add((IContributionItem)new ControlContribution(String.valueOf(clazz.getName()) + ".constrain"){

            protected Control createControl(Composite parent) {
                ThreadListView.this.searchCombo = new Combo(parent, 4);
                ThreadListView.this.searchCombo.setToolTipText("Search");
                ThreadListView.this.searchCombo.add("");
                if (ThreadListView.this.viewer.getInput() instanceof IBBSBoard) {
                    ThreadListView.this.restoreSearchWord((IResource)((IBBSBoard)ThreadListView.this.viewer.getInput()).getLogFolder());
                }
                ThreadListView.this.searchCombo.addSelectionListener(new SelectionListener(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.selected(e);
                    }

                    private void selected(SelectionEvent e) {
                        String text = ThreadListView.access$5(4.access$0(this.this$1)).getText();
                        if (text.length() > 0) {
                            if (Arrays.asList(ThreadListView.access$5(4.access$0(this.this$1)).getItems()).contains(text)) {
                                ThreadListView.access$5(4.access$0(this.this$1)).remove(text);
                            }
                            ThreadListView.access$5(4.access$0(this.this$1)).add(text, 1);
                        }
                        ThreadListView.access$7(4.access$0(this.this$1), text);
                        ThreadListView.access$8(4.access$0(this.this$1));
                        ThreadListView.access$5(4.access$0(this.this$1)).setText(text);
                        if (ThreadListView.access$1(4.access$0(this.this$1)).getVisibleExpandedElements().length == 0) {
                            ThreadListView.access$9(4.access$0(this.this$1));
                        }
                    }
                });
                return ThreadListView.this.searchCombo;
            }

            static /* synthetic */ ThreadListView access$0(4 var0) {
                return var0.ThreadListView.this;
            }
        });
        manager.add(this.reloadAction);
        manager.add(this.abortAction);
    }

    private void makeColumns() {
        TableTree table = this.viewer.getTableTree();
        table.getTable().setHeaderVisible(true);
        table.getTable().setLinesVisible(true);
        TableColumn col = new TableColumn(table.getTable(), 16384);
        col.setText("Rank");
        col.setWidth(80);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Title");
        col.setWidth(400);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Response");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Cache");
        col.setWidth(50);
        col = new TableColumn(table.getTable(), 16384);
        col.setText("Read");
        col.setWidth(50);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.reloadAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.run(ThreadListView.this.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        if (ThreadListView.access$1(6.access$0(this.this$1)).getInput() instanceof IBBSBoard) {
                            ThreadListView.access$11().finest("refresh");
                            ((IBBSBoard)ThreadListView.access$1(6.access$0(this.this$1)).getInput()).updateThreadList(6.access$0(this.this$1).getSite().getWorkbenchWindow());
                        }
                    }
                });
            }

            static /* synthetic */ ThreadListView access$0(6 var0) {
                return var0.ThreadListView.this;
            }
        };
        this.reloadAction.setText("Reload");
        this.reloadAction.setToolTipText("Reload thread list");
        try {
            this.reloadAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "refresh_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.abortAction = new Action(){

            public void run() {
                ThreadListView.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ThreadListView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object first = ((IStructuredSelection)selection).getFirstElement();
                    if (first instanceof IThreadContentProvider) {
                        logger.finest("begin");
                        IThreadContentProvider thread = (IThreadContentProvider)first;
                        IWorkbenchPage page = ThreadListView.this.getSite().getPage().getWorkbenchWindow().getActivePage();
                        try {
                            IEditorPart part;
                            logger.finest("openEditor");
                            ThreadEditorInput threadEditorInput = new ThreadEditorInput(thread);
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = class$1 = Class.forName("monalipse.editors.ThreadViewerEditor");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((part = page.openEditor((IEditorInput)threadEditorInput, clazz.getName())) instanceof ThreadViewerEditor) {
                                logger.finest("updateThread");
                                ((ThreadViewerEditor)part).updateThread(-1);
                            }
                        }
                        catch (PartInitException ex) {
                            ex.printStackTrace();
                        }
                        logger.finest("done");
                    } else {
                        ThreadListView.this.viewer.setExpandedState(first, !ThreadListView.this.viewer.getExpandedState(first));
                    }
                }
            }
        };
        this.bookmarkAction = new BookmarkAction();
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ThreadListView.this.doubleClickAction.run();
            }
        });
    }

    private void hookDragAndDrop() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ void access$7(ThreadListView threadListView, String string) {
        threadListView.constraint = string;
    }

    static /* synthetic */ void access$8(ThreadListView threadListView) {
        threadListView.refreshList();
    }

    static /* synthetic */ void access$9(ThreadListView threadListView) {
        threadListView.expandFirstFragment();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    private class ThreadListContentProvider
    extends LabelProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    ITableLabelProvider {
        private static final int THREAD_LIST_DIVIDE_SIZE = 50;
        static /* synthetic */ Class class$0;

        ThreadListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IBBSBoard) {
                IThreadContentProvider[] cps = ((IBBSBoard)inputElement).getThreadList(ThreadListView.this.constraint);
                Object[] fragments = new Fragment[(cps.length + 50 - 1) / 50];
                int i = 0;
                while (i < fragments.length) {
                    fragments[i] = new Fragment(cps, 50 * i);
                    ++i;
                }
                return fragments;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Fragment) {
                return ((Fragment)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Fragment) {
                return ThreadListView.this.viewer.getInput();
            }
            if (element instanceof IThreadContentProvider) {
                int index = ((IThreadContentProvider)element).getIndex() / 50;
                Object[] list = this.getElements(ThreadListView.this.viewer.getInput());
                if (index >= 0 && index < list.length) {
                    return list[index];
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Fragment || element instanceof IBBSBoard;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public String getText(Object element) {
            if (element instanceof Fragment) {
                return ((Fragment)element).getText();
            }
            if (element instanceof IThreadContentProvider) {
                return ((IThreadContentProvider)element).getName();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IThreadContentProvider && columnIndex == 1 && element instanceof IBBSReference) {
                return MonalipsePlugin.getDefault().getLabelImageOf((IBBSReference)element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IThreadContentProvider) {
                IThreadContentProvider thread = (IThreadContentProvider)element;
                switch (columnIndex) {
                    case 0: {
                        return String.valueOf(thread.getIndex() + 1);
                    }
                    case 1: {
                        return thread.getName();
                    }
                    case 2: {
                        return String.valueOf(thread.getResponseCountHint());
                    }
                    case 3: {
                        return String.valueOf(thread.getCachedCount());
                    }
                    case 4: {
                        return this.getPersistentCountProperty(thread, ".read");
                    }
                }
            } else if (element instanceof Fragment && columnIndex == 0) {
                return ((Fragment)element).getText();
            }
            return "";
        }

        private String getPersistentCountProperty(IThreadContentProvider thread, String type) {
            block6: {
                try {
                    String count;
                    if (!(ThreadListView.this.viewer.getInput() instanceof IBBSBoard)) break block6;
                    IFolder iFolder = ((IBBSBoard)ThreadListView.this.viewer.getInput()).getLogFolder();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((count = iFolder.getPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(thread.getID()) + type))) == null) {
                        count = "0";
                    }
                    return count;
                }
                catch (CoreException coreException) {}
            }
            return "0";
        }

        private class Fragment {
            private IThreadContentProvider[] children;
            private int start;

            public Fragment(IThreadContentProvider[] children, int start) {
                this.children = children;
                this.start = start;
            }

            public IThreadContentProvider[] getChildren() {
                IThreadContentProvider[] ch = new IThreadContentProvider[Math.min(this.children.length - this.start, 50)];
                int i = 0;
                while (i < ch.length) {
                    ch[i] = this.children[this.start + i];
                    ++i;
                }
                return ch;
            }

            public String getText() {
                return String.valueOf(this.start + 1) + "..." + (this.start + 50);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Fragment) {
                    return ((Fragment)obj).start == this.start;
                }
                return false;
            }

            public int hashCode() {
                return this.start;
            }
        }
    }
}

