/*
 * Decompiled with CFR 0.152.
 */
package monalipse.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import monalipse.MonalipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMonalipseProjectCreationWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;
    private IConfigurationElement configElement;
    private static String PAGE_PROBLEMS_TITLE = MonalipsePlugin.getResourceString("NewProject.errorOpeningPage");
    private static String WINDOW_PROBLEMS_TITLE = MonalipsePlugin.getResourceString("NewProject.errorOpeningWindow");
    private static String INITIAL_PROJECT_NAME = "monalipse.log";

    public NewMonalipseProjectCreationWizard() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = workbenchSettings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("monalipseNewProjectPage"){

            public void setPageComplete(boolean complete) {
                boolean exists = false;
                IProject[] proj = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < proj.length) {
                    try {
                        if (proj[i].getNature("monalipse.monalipsenature") != null) {
                            exists = true;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
                super.setPageComplete(complete && !exists);
                if (complete && exists) {
                    this.setErrorMessage(MonalipsePlugin.getResourceString("NewProject.errorAlreadyExists"));
                }
            }

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.validate((Control)parent);
            }

            private void validate(Control control) {
                Text text;
                if (control instanceof Composite) {
                    Control[] children = ((Composite)control).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.validate(children[i]);
                        ++i;
                    }
                } else if (control instanceof Text && (text = (Text)control).getText().equals(INITIAL_PROJECT_NAME)) {
                    NewMonalipseProjectCreationWizard.this.getShell().getDisplay().asyncExec(new Runnable(text){
                        private final /* synthetic */ Text val$text;
                        {
                            this.val$text = text;
                        }

                        public void run() {
                            this.val$text.setText(NewMonalipseProjectCreationWizard.access$0());
                        }
                    });
                }
            }
        };
        this.mainPage.setTitle(MonalipsePlugin.getResourceString("NewProject.title"));
        this.mainPage.setDescription(MonalipsePlugin.getResourceString("NewProject.description"));
        this.mainPage.setInitialProjectName(INITIAL_PROJECT_NAME);
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        IPath newPath = this.mainPage.getLocationPath();
        PluginVersionIdentifier uiVersion = Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.ui").getVersionIdentifier();
        if (uiVersion.isGreaterOrEqualTo(new PluginVersionIdentifier(2, 1, 0))) {
            if (defaultPath.append(INITIAL_PROJECT_NAME).equals((Object)newPath)) {
                newPath = null;
            }
        } else if (defaultPath.equals((Object)newPath)) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewMonalipseProjectCreationWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.caseVariantExistsError", new String[]{newProjectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.internalError", new Object[]{t.getMessage()}));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private static void addMonalipseNature(IProject project, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        if (!project.hasNature("monalipse.monalipsenature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "monalipse.monalipsenature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
        monitor.worked(1);
        monitor.done();
    }

    private void configureProject(IProject project, IProgressMonitor monitor) throws CoreException {
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 4000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            NewMonalipseProjectCreationWizard.addMonalipseNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.configureProject(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MonalipsePlugin.getResourceString("NewProject.windowTitle"));
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }
}

