package monalipse.editors;

import monalipse.server.IThreadContentProvider;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;

public class ThreadEditorInput implements IEditorInput, IPersistableElement, IAdaptable
{
	private String url;
	private String title;
	private String tooltip;

	public ThreadEditorInput(String url, String title, String tooltip)
	{
		this.url = url;
		this.title = title.trim();
		this.tooltip = tooltip;
	}
	
	public ThreadEditorInput(IThreadContentProvider thread)
	{
		this.url = thread.getURL().toExternalForm();
		this.title = thread.getName().trim();
		this.tooltip = thread.getName() + "\n" + url;
	}
	
	public boolean equals(Object obj)
	{
		if(obj instanceof ThreadEditorInput)
		{
			ThreadEditorInput ei = (ThreadEditorInput)obj;
			return ei.url.equals(url);
		}
		return false;
	}
	
	public int hashCode()
	{
		return url.hashCode();
	}
	
	public String getURL()
	{
		return url;
	}
	
	public String getTitle()
	{
		return title;
	}
	
	public void setTitle(String title)
	{
		this.title = title.trim();
	}
	
	public void setToolTipText(String tooltip)
	{
		this.tooltip = tooltip;
	}
	
	public boolean exists()
	{
		return true;
	}

	public Object getAdapter(Class adapter)
	{
		return null;
	}

	public String getFactoryId()
	{
		return ThreadEditorInputFactory.getFactoryId();
	}

	public ImageDescriptor getImageDescriptor()
	{
		return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(".2chdat");
	}

	public String getName()
	{
		return title;
	}

	public IPersistableElement getPersistable()
	{
		return this;
	}

	public String getToolTipText()
	{
		return tooltip;
	}

	public void saveState(IMemento memento)
	{
		ThreadEditorInputFactory.saveState(memento, this);
	}

}
