/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.moreemacs.handlers.RectangleExecution;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.ColumnUtils;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import jp.sourceforge.moreemacs.utils.DocumentTransaction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;

public final class KillRectangleExecution
extends RectangleExecution {
    @Override
    public void execute() throws BadLocationException {
        if (!this.textEditor.isEditable()) {
            return;
        }
        ITextSelection selection = this.getSelection(true);
        int start = selection.getOffset();
        int startRow = this.doc.getLineOfOffset(start);
        int startColumn = ColumnUtils.getColumn(this.doc, start, this.getTabStop());
        int end = start + selection.getLength();
        int endRow = this.doc.getLineOfOffset(end);
        int endColumn = ColumnUtils.getColumn(this.doc, end, this.getTabStop());
        if (startColumn > endColumn) {
            int work = startColumn;
            startColumn = endColumn;
            endColumn = work;
        }
        DocumentTransaction transaction = new DocumentTransaction(this.doc);
        transaction.begin(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
        try {
            List<String> rectangle = this.killRectangle(this.doc, startRow, startColumn, endRow, endColumn);
            KillRectangleExecution.setRectangle(rectangle);
        }
        finally {
            transaction.end();
        }
    }

    private List<String> killRectangle(IDocument doc, int startRow, int startColumn, int endRow, int endColumn) throws BadLocationException {
        ArrayList<String> rectangle = new ArrayList<String>();
        int i = startRow;
        while (i <= endRow) {
            String str = this.killString(doc, i, startColumn, endColumn);
            rectangle.add(str);
            ++i;
        }
        return rectangle;
    }

    private String killString(IDocument doc, int row, int startColumn, int endColumn) throws BadLocationException {
        IRegion line = doc.getLineInformation(row);
        StringBuilder builder = new StringBuilder();
        int column = 0;
        int cutOffset = 0;
        int cutLength = 0;
        DocumentCharSequence seq = new DocumentCharSequence(doc, line.getOffset(), line.getLength());
        CodePointIterator itr = new CodePointIterator(seq);
        while (itr.hasNext()) {
            if (column >= endColumn) break;
            int offset = line.getOffset() + itr.index();
            int codePoint = itr.next();
            int nextColumn = ColumnUtils.getNextColumn(column, codePoint, this.getTabStop());
            if (nextColumn < startColumn + 1) {
                column = nextColumn;
                continue;
            }
            if (cutLength == 0) {
                cutOffset = offset;
            }
            builder.appendCodePoint(codePoint);
            cutLength += Character.charCount(codePoint);
            column = nextColumn;
        }
        doc.replace(cutOffset, cutLength, "");
        this.cursor.move(cutOffset);
        int i = 0;
        while (i < endColumn - column) {
            builder.append(' ');
            ++i;
        }
        return builder.toString();
    }
}

