/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.utils;

import jp.sourceforge.moreemacs.utils.CharacterUtils;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class ColumnUtils {
    private ColumnUtils() {
    }

    public static int getColumn(IDocument doc, int offset, int tabStop) throws BadLocationException {
        IRegion line = doc.getLineInformationOfOffset(offset);
        int column = 0;
        DocumentCharSequence seq = new DocumentCharSequence(doc, line.getOffset(), offset - line.getOffset());
        CodePointIterator itr = new CodePointIterator(seq);
        while (itr.hasNext()) {
            int codePoint = itr.next();
            column = ColumnUtils.getNextColumn(column, codePoint, tabStop);
        }
        return column;
    }

    public static int getNextColumn(int column, int codePoint, int tabStop) {
        if (codePoint == 9) {
            return column - column % tabStop + tabStop;
        }
        return column + CharacterUtils.getWidth(codePoint);
    }
}

