/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.utils;

import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;

public final class DocumentTransaction {
    private IDocumentExtension4 sessionManager;
    private DocumentRewriteSession session;

    public DocumentTransaction(IDocument doc) {
        if (doc instanceof IDocumentExtension4) {
            this.sessionManager = (IDocumentExtension4)doc;
        }
    }

    public boolean isAvailable() {
        return this.sessionManager != null;
    }

    public void begin() {
        this.begin(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
    }

    public void begin(DocumentRewriteSessionType type) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.session != null) {
            throw new IllegalStateException("session already started");
        }
        this.session = this.sessionManager.startRewriteSession(type);
    }

    public void end() {
        if (!this.isAvailable()) {
            return;
        }
        if (this.session == null) {
            throw new IllegalStateException("session is not started");
        }
        this.sessionManager.stopRewriteSession(this.session);
        this.session = null;
    }
}

