/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import jp.morpho.server.ThreadServer;
import jp.morpho.webapp.sql.DatabaseSpec;
import jp.morpho.webapp.sql.PersistenceConnectionHolder;

public class ConnectionPoolDataSource
extends ThreadServer
implements javax.sql.ConnectionPoolDataSource,
DataSource,
ConnectionEventListener {
    Logger log;
    private final DatabaseSpec spec;
    private int minConnections;
    private int maxConnections;
    private Stack connectionStack;
    private Stack usedConnectionStack;
    private boolean closed;
    private int maxIdleTime;
    static /* synthetic */ Class class$0;

    public ConnectionPoolDataSource(DatabaseSpec spec) {
        super(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.webapp.sql.ConnectionPoolDataSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.minConnections = 0;
        this.maxConnections = 0;
        this.maxIdleTime = 0;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            cl.loadClass(spec.getDriver()).newInstance();
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage());
        }
        this.spec = spec;
        this.connectionStack = new Stack();
        this.usedConnectionStack = new Stack();
        this.closed = false;
        this.maxIdleTime = 30000;
    }

    private void pushConnection() throws SQLException {
        Connection conn = null;
        conn = this.spec.getInfo() == null ? DriverManager.getConnection(this.spec.getUrl()) : DriverManager.getConnection(this.spec.getUrl(), this.spec.getInfo());
        PersistenceConnectionHolder pc = new PersistenceConnectionHolder(conn);
        pc.addConnectionEventListener(this);
        this.connectionStack.push(pc);
    }

    public int getLoginTimeout() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        DriverManager.setLoginTimeout(seconds);
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        DriverManager.setLogWriter(out);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        PooledConnection pc = null;
        while (true) {
            if (this.connectionStack.size() > 0) break;
            if (this.maxConnections == 0 || this.usedConnectionStack.size() < this.maxConnections) {
                this.pushConnection();
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        pc = (PooledConnection)this.connectionStack.pop();
        this.usedConnectionStack.push(pc);
        this.notifyAll();
        return pc;
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        throw new SQLException("operation not supported.");
    }

    public Connection getConnection() throws SQLException {
        return this.getPooledConnection().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("operation not supported.");
    }

    public synchronized void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (this.usedConnectionStack.remove(pc)) {
            this.connectionStack.push(pc);
        }
        this.notify();
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getMaxConnections() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        return this.maxConnections;
    }

    public int getMinConnections() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        return this.minConnections;
    }

    public DatabaseSpec getDatabaseSpec() throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        return this.spec;
    }

    public void setMaxConnections(int i) throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        this.maxConnections = i;
    }

    public void setMinConnections(int i) throws SQLException {
        if (this.closed) {
            throw new SQLException("DataSource closed.");
        }
        this.minConnections = i;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int i) {
        this.maxIdleTime = i;
    }

    public void run() {
        int i;
        ConnectionPoolDataSource connectionPoolDataSource = this;
        synchronized (connectionPoolDataSource) {
            try {
                i = 0;
                while (i < this.minConnections) {
                    this.pushConnection();
                    ++i;
                }
            }
            catch (Exception e) {
                this.log.log(Level.FINEST, e.getMessage(), e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        try {
            this.log.info("Started ConnectionPoolDataSource[" + this.getDatabaseSpec().toString() + "]");
        }
        catch (Exception exception) {}
        block24: while (this.isRunning() && !this.isShutdown()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int count = (this.connectionStack.size() + this.usedConnectionStack.size() - this.minConnections) / 5;
            if (count <= 0) {
                count = 1;
            }
            i = 0;
            while (i < count) {
                if (!this.isRunning() || this.isShutdown()) continue block24;
                ConnectionPoolDataSource connectionPoolDataSource2 = this;
                synchronized (connectionPoolDataSource2) {
                    if (this.connectionStack.size() + this.usedConnectionStack.size() <= this.minConnections) {
                        continue block24;
                    }
                    if (this.connectionStack.size() == 0) {
                        continue block24;
                    }
                    PersistenceConnectionHolder pch = (PersistenceConnectionHolder)this.connectionStack.get(0);
                    if (pch.getIdleTime() >= (long)this.getMaxIdleTime()) {
                        this.connectionStack.remove(pch);
                        pch.removeConnectionEventListener(this);
                        try {
                            pch.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        ConnectionPoolDataSource connectionPoolDataSource3 = this;
        synchronized (connectionPoolDataSource3) {
            this.closed = true;
            while (this.connectionStack.size() > 0) {
                PooledConnection pc = (PooledConnection)this.connectionStack.pop();
                try {
                    pc.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.connectionStack = null;
            while (this.usedConnectionStack.size() > 0) {
                PooledConnection pc = (PooledConnection)this.usedConnectionStack.pop();
                pc.removeConnectionEventListener(this);
                try {
                    pc.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.usedConnectionStack = null;
        }
        try {
            this.log.info("Stopped ConnectionPoolDataSource[" + this.getDatabaseSpec().toString() + "]");
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.run();
    }
}

