/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import jp.morpho.webapp.sql.PersistenceConnectionHolder;

public class PersistenceConnection
implements Connection {
    private final String ERROR_CONNECTION_CLOSED = "connection closed.";
    private PersistenceConnectionHolder pcHolder;
    private Connection wrapped = null;
    private boolean closed;

    public PersistenceConnection(PersistenceConnectionHolder pcHolder, Connection wrap) {
        if (pcHolder == null) {
            throw new IllegalArgumentException("PersistenceConnectionHolder must not null");
        }
        if (wrap == null) {
            throw new IllegalArgumentException("wrap must not null");
        }
        this.pcHolder = pcHolder;
        this.wrapped = wrap;
        this.closed = false;
    }

    public void setReadOnly(boolean arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setReadOnly(arg1);
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.isReadOnly();
    }

    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.pcHolder.fireConnectionClosed();
    }

    public boolean isClosed() throws SQLException {
        return this.closed || this.wrapped.isClosed();
    }

    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.commit();
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.clearWarnings();
    }

    public Statement createStatement(int arg1, int arg2, int arg3) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.createStatement(arg1, arg2, arg3);
    }

    public Statement createStatement(int arg1, int arg2) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.createStatement(arg1, arg2);
    }

    public Statement createStatement() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.createStatement();
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getCatalog();
    }

    public int getHoldability() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.getWarnings();
    }

    public String nativeSQL(String arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.nativeSQL(arg1);
    }

    public CallableStatement prepareCall(String arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareCall(arg1);
    }

    public CallableStatement prepareCall(String arg1, int arg2, int arg3, int arg4) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareCall(arg1, arg2, arg3, arg4);
    }

    public CallableStatement prepareCall(String arg1, int arg2, int arg3) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareCall(arg1, arg2, arg3);
    }

    public PreparedStatement prepareStatement(String arg1, String[] arg2) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1, arg2);
    }

    public PreparedStatement prepareStatement(String arg1, int arg2, int arg3) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1, arg2, arg3);
    }

    public PreparedStatement prepareStatement(String arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1);
    }

    public PreparedStatement prepareStatement(String arg1, int[] arg2) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1, arg2);
    }

    public PreparedStatement prepareStatement(String arg1, int arg2) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1, arg2);
    }

    public PreparedStatement prepareStatement(String arg1, int arg2, int arg3, int arg4) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.prepareStatement(arg1, arg2, arg3, arg4);
    }

    public void releaseSavepoint(Savepoint arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.releaseSavepoint(arg1);
    }

    public void rollback(Savepoint arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.rollback(arg1);
    }

    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.rollback();
    }

    public void setAutoCommit(boolean arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setAutoCommit(arg1);
    }

    public void setCatalog(String arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setCatalog(arg1);
    }

    public void setHoldability(int arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setHoldability(arg1);
    }

    public Savepoint setSavepoint(String arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.setSavepoint(arg1);
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        return this.wrapped.setSavepoint();
    }

    public void setTransactionIsolation(int arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setTransactionIsolation(arg1);
    }

    public void setTypeMap(Map arg1) throws SQLException {
        if (this.closed) {
            throw new SQLException("connection closed.");
        }
        this.wrapped.setTypeMap(arg1);
    }
}

