/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.sql;

import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import jp.morpho.config.Configuration;
import jp.morpho.util.ConversionList;
import jp.morpho.util.PrimitiveHolderList;
import jp.morpho.webapp.Plugin;
import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.sql.ConnectionPoolDataSource;
import jp.morpho.webapp.sql.DatabaseSpec;

public class PersistenceDatabaseConnector
implements Plugin {
    private PluginContext pluginContext = null;
    private PrimitiveHolderList configPathList = new ConversionList();
    private Map poolMap = new HashMap();
    private int minConnections = 0;
    private int maxConnections = 0;
    private int maxIdleTime = 30000;
    static /* synthetic */ Class class$0;

    public synchronized void removeAllConfigurationFilePaths() {
        this.configPathList.clear();
    }

    public synchronized void addConfigurationFilePath(String path) {
        this.configPathList.add((Object)path);
    }

    public synchronized String[] getConfigurationFilePaths() {
        Object[] paths = new String[this.configPathList.size()];
        return (String[])this.configPathList.toArray(paths);
    }

    public final synchronized String getPluginKey() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.morpho.webapp.sql.PersistenceDatabaseConnector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public synchronized void pluginActivate() throws PluginException {
        ServletContext sc = this.pluginContext.getFrameworkContext().getServletContext();
        String[] paths = this.getConfigurationFilePaths();
        int i = 0;
        while (i < paths.length) {
            Exception e3;
            Object var7_8;
            InputStream in = null;
            try {
                try {
                    URL url = sc.getResource(paths[i]);
                    in = url.openStream();
                    Configuration config = new Configuration();
                    config.configure((Object)this, in);
                }
                catch (Exception e2) {
                    Logger log = Logger.getLogger("jp.morpho");
                    log.log(Level.WARNING, e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    in.close();
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var7_8 = null;
            try {
                in.close();
            }
            catch (Exception e3) {
                // empty catch block
            }
            ++i;
        }
    }

    public synchronized void pluginRemove() throws PluginException {
        this.pluginContext = null;
        String[] keys = new String[this.poolMap.size()];
        keys = this.poolMap.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            ConnectionPoolDataSource pool = (ConnectionPoolDataSource)this.poolMap.get(keys[i]);
            try {
                pool.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public synchronized void setPluginContext(PluginContext fc) throws PluginException {
        this.pluginContext = fc;
    }

    public int getMaxConnections() throws SQLException {
        return this.maxConnections;
    }

    public int getMinConnections() throws SQLException {
        return this.minConnections;
    }

    public void setMaxConnections(int i) throws SQLException {
        this.maxConnections = i;
    }

    public void setMinConnections(int i) throws SQLException {
        this.minConnections = i;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int i) {
        this.maxIdleTime = i;
    }

    public synchronized void addDatabase(DatabaseSpec spec) throws SQLException {
        if (this.poolMap.containsKey(spec.toString())) {
            throw new IllegalArgumentException("Already exists: " + spec.toString());
        }
        Logger log = Logger.getLogger("jp.morpho");
        log.finest("Add new connection pool: " + spec.toString());
        try {
            ConnectionPoolDataSource pool = new ConnectionPoolDataSource(spec);
            pool.setMaxConnections(this.getMaxConnections());
            pool.setMinConnections(this.getMinConnections());
            pool.setMaxIdleTime(this.getMaxIdleTime());
            this.poolMap.put(spec.toString(), pool);
            pool.start();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }

    public synchronized DataSource getDataSource(DatabaseSpec spec, boolean connect) throws SQLException {
        ConnectionPoolDataSource pool = (ConnectionPoolDataSource)this.poolMap.get(spec.toString());
        if (pool != null) {
            return pool;
        }
        if (connect) {
            this.addDatabase(spec);
            return (ConnectionPoolDataSource)this.poolMap.get(spec.toString());
        }
        throw new SQLException("ConnectionPool not found.");
    }

    public synchronized DataSource getDataSource(DatabaseSpec spec) throws SQLException {
        return this.getDataSource(spec, true);
    }
}

